package com.biz.crm.supermarket.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTotalWarehouseStoreRespVo;
import com.biz.crm.supermarket.service.IKmsTotalWarehouseStoreService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 总仓门店
 *
 * @author lf
 * @date 2021-06-26 11:20:06
 */
@Slf4j
@RestController
@RequestMapping("/kmstotalwarehousestore")
@Api(tags = "总仓门店")
public class KmsTotalWarehouseStoreController {
    @Autowired
    private IKmsTotalWarehouseStoreService kmsTotalWarehouseStoreService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsTotalWarehouseStoreRespVo>> list(@RequestBody KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo) {
        PageResult<KmsTotalWarehouseStoreRespVo> result = kmsTotalWarehouseStoreService.findList(kmsTotalWarehouseStoreReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsTotalWarehouseStoreRespVo> query(@RequestBody KmsTotalWarehouseStoreReqVo reqVo) {
        KmsTotalWarehouseStoreRespVo respVo = kmsTotalWarehouseStoreService.query(reqVo.getId());
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo) {
        kmsTotalWarehouseStoreService.save(kmsTotalWarehouseStoreReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo) {
        kmsTotalWarehouseStoreService.update(kmsTotalWarehouseStoreReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsTotalWarehouseStoreService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsTotalWarehouseStoreService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsTotalWarehouseStoreService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
