package com.biz.crm.supermarket.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectAccountReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectAccountRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;

import java.util.List;

/**
 * 抓单账号管理接口
 *
 * @author Gavin
 * @date 2021-04-13 23:19:46
 */
public interface IKmsTenantryDirectAccountService extends IService<KmsTenantryDirectAccountEntity> {

    /**
     * 列表
     *
     * @param kmsTenantryDirectAccountReqVo
     * @return PageResult<KmsTenantryDirectAccountRespVo>
     */
    PageResult<KmsTenantryDirectAccountRespVo> findList(KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsTenantryDirectAccountRespVo
     */
    KmsTenantryDirectAccountRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsTenantryDirectAccountReqVo
     * @return
     */
    void save(KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo);

    /**
     * 更新
     *
     * @param kmsTenantryDirectAccountReqVo
     * @return
     */
    void update(KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

