package com.biz.crm.supermarket.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTotalWarehouseStoreRespVo;
import com.biz.crm.supermarket.model.KmsTotalWarehouseStoreEntity;

import java.util.List;

/**
 * 总仓门店接口
 *
 * @author lf
 * @date 2021-06-26 11:20:06
 */
public interface IKmsTotalWarehouseStoreService extends IService<KmsTotalWarehouseStoreEntity> {

    /**
     * 列表
     *
     * @param kmsTotalWarehouseStoreReqVo
     * @return PageResult<KmsTotalWarehouseStoreRespVo>
     */
    PageResult<KmsTotalWarehouseStoreRespVo> findList(KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsTotalWarehouseStoreRespVo
     */
    KmsTotalWarehouseStoreRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsTotalWarehouseStoreReqVo
     * @return
     */
    void save(KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo);

    /**
     * 更新
     *
     * @param kmsTotalWarehouseStoreReqVo
     * @return
     */
    void update(KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

