package com.biz.crm.trans.vo;

import java.io.Serializable;
import java.util.List;

import com.google.common.collect.Lists;

import lombok.Data;

/**
 * @Project crm
 * @PackageName com.biz.crm.vo
 * @ClassName TransDataVo
 * @Author Gavin
 * @Date 2021/5/18 上午10:55
 * @Description 单据数据转换对象
 */
@Data
public class TransDataVo implements Serializable {
    private static final long serialVersionUID = 5867049646817676366L;

    /**
     * 单据类型
     */
    private String orderType;

    /**
     * 单据日期
     */
    private String orderDate;

    /**
     * 门店转换数据
     */
    private TransDataStoreVo storeVos;

    /**
     * 商品转换数据
     */
    private List<TransDataGoodsVo> goodsVos = Lists.newArrayList();

}