package com.biz.crm;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.net.InetAddress;

@SpringBootApplication
@EnableEurekaClient
@EnableFeignClients
@EnableScheduling
@EnableAsync
@MapperScan(value={"com.biz.crm.**.mapper*"})
@Slf4j
public class KmsApplication {

    @SneakyThrows
    public static void main(String[] args){
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        ConfigurableApplicationContext application = SpringApplication.run(KmsApplication.class, args);
        Environment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\t" +
                "Application crm-sfa is running! Access URLs:\n\t" +
                "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
//            "外部访问地址: \thttp://" + ip + ":" + port + path + "/\n\t" +
                "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
                "----------------------------------------------------------");
    }
}
