package com.biz.crm.acceptanceform.controller;

import com.biz.crm.acceptanceform.service.IKmsAcceptanceGoodsService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceGoodsReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceGoodsRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 验收单原始单据详情
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Slf4j
@RestController
@RequestMapping("/kmsacceptancegoods")
@Api(tags = "验收单商品信息")
public class KmsAcceptanceGoodsController {
    @Autowired
    private IKmsAcceptanceGoodsService kmsAcceptanceGoodsService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsAcceptanceGoodsRespVo>> list(@RequestBody KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        PageResult<KmsAcceptanceGoodsRespVo> result=kmsAcceptanceGoodsService.findList(kmsAcceptanceGoodsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsAcceptanceGoodsRespVo> query(@RequestBody KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        KmsAcceptanceGoodsRespVo respVo=kmsAcceptanceGoodsService.query(kmsAcceptanceGoodsReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        kmsAcceptanceGoodsService.save(kmsAcceptanceGoodsReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        kmsAcceptanceGoodsService.update(kmsAcceptanceGoodsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        kmsAcceptanceGoodsService.deleteBatch(kmsAcceptanceGoodsReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        kmsAcceptanceGoodsService.enableBatch(kmsAcceptanceGoodsReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo) {
        kmsAcceptanceGoodsService.disableBatch(kmsAcceptanceGoodsReqVo);
        return Result.ok("禁用成功");
    }
}
