package com.biz.crm.acceptanceform.controller;

import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceStatusRecordReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceStatusRecordRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 验收单状态流转表
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Slf4j
@RestController
@RequestMapping("/kmsacceptancestatusrecord")
//@Api(tags = "验收单状态流转表")
public class KmsAcceptanceStatusRecordController {
    @Autowired
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsAcceptanceStatusRecordRespVo>> list(@RequestBody KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        PageResult<KmsAcceptanceStatusRecordRespVo> result=kmsAcceptanceStatusRecordService.findList(kmsAcceptanceStatusRecordReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsAcceptanceStatusRecordRespVo> query(@RequestBody KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        KmsAcceptanceStatusRecordRespVo respVo=kmsAcceptanceStatusRecordService.query(kmsAcceptanceStatusRecordReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        kmsAcceptanceStatusRecordService.save(kmsAcceptanceStatusRecordReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        kmsAcceptanceStatusRecordService.update(kmsAcceptanceStatusRecordReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        kmsAcceptanceStatusRecordService.deleteBatch(kmsAcceptanceStatusRecordReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        kmsAcceptanceStatusRecordService.enableBatch(kmsAcceptanceStatusRecordReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo) {
        kmsAcceptanceStatusRecordService.disableBatch(kmsAcceptanceStatusRecordReqVo);
        return Result.ok("禁用成功");
    }
}
