package com.biz.crm.acceptanceform.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormExportRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;

/**
 * 转换后验收单接口
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
public interface IKmsAcceptanceFormService extends IService<KmsAcceptanceFormEntity> {

    /**
     * 列表
     *
     * @param kmsAcceptanceFormReqVo
     * @return PageResult<KmsAcceptanceFormRespVo>
     */
    PageResult<KmsAcceptanceFormRespVo> findList(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 查询
     *
     * @param kmsAcceptanceFormReqVo
     * @return KmsAcceptanceFormRespVo
     */
    KmsAcceptanceFormRespVo query(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 新增
     *
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    void save(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 更新
     *
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    void update(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 删除
     *
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    void deleteBatch(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 启用
     *
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    void enableBatch(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 禁用
     *
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    void disableBatch(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 手动转换验收单
     *
     * @param kmsAcceptanceFormReqVo
     */
    void manualTrans(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 自动转换验收单
     *
     * @param dwRespVo
     */
    void autoTransData(KmsAcceptanceFormDetailDwRespVo dwRespVo);

    /**
     * 验收单导出
     *
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    PageResult<KmsAcceptanceFormExportRespVo> listForExport(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 稽核匹配
     * @param orderNumber
     */
    void auditMatch(String orderNumber);
}

