package com.biz.crm.confadmin.helper;

import com.biz.crm.base.BusinessException;
import com.biz.crm.confadmin.model.KmsInterfaceParamOptionEntity;
import com.biz.crm.confadmin.model.KmsInterfaceSubParamOptionEntity;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.base.BaseDateFlagConstants;
import com.biz.crm.nebular.kms.confadmin.base.ComomStatus;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamOptionReqVo;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceSubParamOptionReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.helper
 * @ClassName KmsInterfaceParamHelper
 * @Author Gavin
 * @Date 2021/5/7 上午11:40
 * @Description 参数管理助手
 */
@Slf4j
@Component
public class KmsInterfaceParamHelper {

    /**
     * 数据校验
     * @param reqVo
     */
    public void paramCheck(KmsInterfaceParamReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getDirectId(),"商超ID[directId]不能为空");
        AssertUtils.isNotEmpty(reqVo.getFieldEn(),"参数属性名[fieldEn]不能为空");
        AssertUtils.isNotEmpty(reqVo.getFieldCn(),"参数文本名[fieldCn]不能为空");
        //是否必填
        String isRequired = reqVo.getIsRequired();
        AssertUtils.isNotEmpty(isRequired,"字段是否必填标示[isRequired]不能为空");
        ComomStatus ifPresentEnum = ComomStatus.getIfPresent(isRequired);
        AssertUtils.isNotNull(ifPresentEnum,"字段是否必填标示数据错误");

        //单据编码
        String orderType = reqVo.getOrderType();
        AssertUtils.isNotEmpty(orderType,"单据类型编码[orderType]不能为空");
        KmsAdminEnum.OrderType orderTypeEnum = KmsAdminEnum.OrderType.getIfPresent(orderType);
        AssertUtils.isNotNull(orderTypeEnum,"单据类型编码数据错误");

        //控件类型
        String fieldClassify = reqVo.getFieldClassify();
        AssertUtils.isNotEmpty(fieldClassify,"控件类型[fieldClassify]不能为空");
        BaseClassifyConstants.FieldClassify fieldClassifyEnum = BaseClassifyConstants.FieldClassify.getIfPresent(fieldClassify);
        AssertUtils.isNotNull(fieldClassifyEnum,"控件类型[fieldClassify]数据错误");
        //参数类型
        String paramClassify = reqVo.getParamClassify();
        AssertUtils.isNotEmpty(paramClassify,"参数类型[paramClassify]不能为空");
        BaseClassifyConstants.ParamClassify paramClassifyEnum = BaseClassifyConstants.ParamClassify.getIfPresent(paramClassify);
        AssertUtils.isNotNull(paramClassifyEnum,"参数类型数据错误");

        //控件类型为下拉单选/多选/时间单选/范围
        if(BaseClassifyConstants.FieldClassify.SELECT.equals(fieldClassifyEnum)
                || BaseClassifyConstants.FieldClassify.CHECKBOX.equals(fieldClassifyEnum)
                || BaseClassifyConstants.FieldClassify.DATE.equals(fieldClassifyEnum)
                || BaseClassifyConstants.FieldClassify.DATERANGE.equals(fieldClassifyEnum)){
            //options校验
            List<KmsInterfaceParamOptionReqVo> options = reqVo.getOptions();
            AssertUtils.isNotEmpty(options,"下拉单选/多选，选项集合[options]不能为空");
            options.forEach(o -> {
                AssertUtils.isNotEmpty(o.getOptionName(),"选项名称[optionName]不能为空");
                AssertUtils.isNotEmpty(o.getOptionValue(),"选项值[optionValue]不能为空");
            });
        }
        //subOptions校验
        if(!BaseClassifyConstants.FieldClassify.DATE.equals(fieldClassifyEnum)
                && !BaseClassifyConstants.FieldClassify.DATERANGE.equals(fieldClassifyEnum)){
            reqVo.setSubOptions(null);
        }
        List<KmsInterfaceSubParamOptionReqVo> subOptions = reqVo.getSubOptions();
        //时间单选
        if(BaseClassifyConstants.FieldClassify.DATE.equals(fieldClassifyEnum)){
            AssertUtils.isNotEmpty(subOptions,"时间单选子参数[subOptions]不能为空");
            if(subOptions.size() != 1){
                throw new BusinessException("时间单选子参数只能为一条");
            }
            KmsInterfaceSubParamOptionReqVo o = subOptions.get(0);
            AssertUtils.isNotEmpty(o.getOptionName(),"子参数中文名[optionName]不能为空");
            AssertUtils.isNotEmpty(o.getOptionValue(),"子参数英文属性名[optionValue]不能为空");
            //时间标示
            String dateFlagClassify = o.getDateFlagClassify();
            AssertUtils.isNotEmpty(dateFlagClassify,"子参数时间标示[dateFlagClassify]不能为空");
            BaseDateFlagConstants.DateFlagClassify dateFlagClassifyEnum = BaseDateFlagConstants.DateFlagClassify
                    .getIfPresent(dateFlagClassify);
            AssertUtils.isNotNull(dateFlagClassifyEnum
                    ,"时间单选子参数时间标示[dateFlagClassify]数据错误只能为"
                            + BaseDateFlagConstants.DateFlagClassify.START.getValue() + "]");
        }
        //时间范围
        if(BaseClassifyConstants.FieldClassify.DATERANGE.equals(fieldClassifyEnum)){
            AssertUtils.isNotEmpty(subOptions,"时间单选子参数[subOptions]不能为空");
            if(subOptions.size() != 2){
                throw new BusinessException("时间范围子参数必须为两条");
            }
            subOptions.forEach(o -> {
                AssertUtils.isNotEmpty(o.getOptionName(),"子参数中文名[optionName]不能为空");
                AssertUtils.isNotEmpty(o.getOptionValue(),"子参数英文属性名[optionValue]不能为空");
                //时间标示
                String dateFlagClassify = o.getDateFlagClassify();
                AssertUtils.isNotEmpty(dateFlagClassify,"子参数时间标示[dateFlagClassify]不能为空");
                BaseDateFlagConstants.DateFlagClassify dateFlagClassifyEnum = BaseDateFlagConstants.DateFlagClassify
                        .getIfPresent(dateFlagClassify);
                AssertUtils.isNotNull(dateFlagClassifyEnum
                        ,"时间范围子参数时间标示[dateFlagClassify]数据错误只能为["
                                + BaseDateFlagConstants.DateFlagClassify.START.getValue() + "]或["
                                + BaseDateFlagConstants.DateFlagClassify.END.getValue() + "]");
            });
            KmsInterfaceSubParamOptionReqVo startSub = subOptions.get(0);
            KmsInterfaceSubParamOptionReqVo endSub = subOptions.get(1);
            if(startSub.getDateFlagClassify().equals(endSub.getDateFlagClassify())){
                throw new BusinessException("时间范围子参数时间标示[dateFlagClassify]不能相同");
            }
        }
    }

    /**
     * 构建属性值实体
     * @param reqVo
     * @return
     */
    public List<KmsInterfaceParamOptionEntity> buildOptionEntity(KmsInterfaceParamReqVo reqVo) {
        return reqVo.getOptions().stream().map(o -> {
            o.setFieldId(reqVo.getId());
            return CrmBeanUtil.copy(o, KmsInterfaceParamOptionEntity.class);
        }).collect(Collectors.toList());
    }

    /**
     * 构建子参数实体
     * @param reqVo
     * @return
     */
    public List<KmsInterfaceSubParamOptionEntity> buildSubOptionEntity(KmsInterfaceParamReqVo reqVo) {
        return reqVo.getSubOptions().stream().map(o -> {
            o.setFieldId(reqVo.getId());
            return CrmBeanUtil.copy(o, KmsInterfaceSubParamOptionEntity.class);
        }).collect(Collectors.toList());
    }
}