package com.biz.crm.confadmin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.confadmin.model.KmsDirectThreadEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectThreadReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectThreadRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 商超单据抓取方式
 *
 * @author Gavin
 * @date 2021-05-06 15:12:00
 */
public interface KmsDirectThreadMapper extends BaseMapper<KmsDirectThreadEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsDirectThreadReqVo
     * @return
     */
    List<KmsDirectThreadRespVo> findList(Page<KmsDirectThreadRespVo> page, @Param("vo") KmsDirectThreadReqVo kmsDirectThreadReqVo);

    /**
     * 查询单据下载方式
     * @param ruleId
     * @return
     */
    KmsDirectThreadRespVo findByGrabRuleId(@Param("ruleId") String ruleId);
}
