package com.biz.crm.finance.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.finance.service.IKmsAuditTemplateDirectService;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateDirectReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 稽核模板商超信息
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Slf4j
@RestController
@RequestMapping("/kmsaudittemplatedirect")
//@Api(tags = "稽核模板商超信息")
public class KmsAuditTemplateDirectController {
    @Autowired
    private IKmsAuditTemplateDirectService kmsAuditTemplateDirectService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsAuditTemplateDirectRespVo>> list(@RequestBody KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        PageResult<KmsAuditTemplateDirectRespVo> result=kmsAuditTemplateDirectService.findList(kmsAuditTemplateDirectReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsAuditTemplateDirectRespVo> query(@RequestBody KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        KmsAuditTemplateDirectRespVo respVo=kmsAuditTemplateDirectService.query(kmsAuditTemplateDirectReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        kmsAuditTemplateDirectService.save(kmsAuditTemplateDirectReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        kmsAuditTemplateDirectService.update(kmsAuditTemplateDirectReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        kmsAuditTemplateDirectService.deleteBatch(kmsAuditTemplateDirectReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        kmsAuditTemplateDirectService.enableBatch(kmsAuditTemplateDirectReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsAuditTemplateDirectReqVo kmsAuditTemplateDirectReqVo) {
        kmsAuditTemplateDirectService.disableBatch(kmsAuditTemplateDirectReqVo);
        return Result.ok("禁用成功");
    }
}
