package com.biz.crm.finance.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAuditMatchRelationService;
import com.biz.crm.nebular.kms.finance.req.KmsAuditMatchRelationReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditMatchRelationRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 稽核匹配关系表接口实现
 *
 * @author Gavin
 * @date 2021-05-27 15:14:19
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsAuditMatchRelationServiceExpandImpl")
public class KmsAuditMatchRelationServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsAuditMatchRelationMapper, KmsAuditMatchRelationEntity> implements IKmsAuditMatchRelationService {

    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditMatchRelationRespVo> findList(KmsAuditMatchRelationReqVo reqVo){
        Page<KmsAuditMatchRelationRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAuditMatchRelationRespVo> list = kmsAuditMatchRelationMapper.findList(page, reqVo);
        return PageResult.<KmsAuditMatchRelationRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsAuditMatchRelationRespVo
     */
    @Override
    public KmsAuditMatchRelationRespVo query(KmsAuditMatchRelationReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAuditMatchRelationReqVo reqVo){
        KmsAuditMatchRelationEntity entity = CrmBeanUtil.copy(reqVo,KmsAuditMatchRelationEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAuditMatchRelationReqVo reqVo){
        KmsAuditMatchRelationEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAuditMatchRelationReqVo reqVo){
        List<KmsAuditMatchRelationEntity> kmsAuditMatchRelationEntities = kmsAuditMatchRelationMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAuditMatchRelationEntities)){
            kmsAuditMatchRelationEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsAuditMatchRelationEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAuditMatchRelationReqVo reqVo){
        //设置状态为启用
        List<KmsAuditMatchRelationEntity> kmsAuditMatchRelationEntities = kmsAuditMatchRelationMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAuditMatchRelationEntities)){
            kmsAuditMatchRelationEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAuditMatchRelationEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAuditMatchRelationReqVo reqVo){
        //设置状态为禁用
        List<KmsAuditMatchRelationEntity> kmsAuditMatchRelationEntities = kmsAuditMatchRelationMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAuditMatchRelationEntities)){
                kmsAuditMatchRelationEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAuditMatchRelationEntities);
    }
}
