package com.biz.crm.grabrule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.grabrule.service.IKmsLoggerDataProcessService;
import com.biz.crm.nebular.kms.grabrule.req.KmsLoggerDataProcessReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsLoggerDataProcessRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 单据抓取日志
 *
 * @author Gavin
 * @date 2021-05-11 11:32:23
 */
@Slf4j
@RestController
@RequestMapping("/grabRespDataController")
@Api(tags = "单据抓取日志")
public class KmsLoggerDataProcessController {
    @Autowired
    private IKmsLoggerDataProcessService kmsLoggerDataProcessService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsLoggerDataProcessRespVo>> list(@RequestBody KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        PageResult<KmsLoggerDataProcessRespVo> result=kmsLoggerDataProcessService.findList(kmsLoggerDataProcessReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsLoggerDataProcessRespVo> query(@RequestBody KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        KmsLoggerDataProcessRespVo respVo=kmsLoggerDataProcessService.query(kmsLoggerDataProcessReqVo);
        return Result.ok(respVo);
    }

    /**
     * 保存抓单日志
     */
    @ApiOperation(value = "保存抓单日志")
    @PostMapping("/receiveFromPython")
    @CrmLog
    public Result save(@RequestBody KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        kmsLoggerDataProcessService.save(kmsLoggerDataProcessReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        kmsLoggerDataProcessService.update(kmsLoggerDataProcessReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        kmsLoggerDataProcessService.deleteBatch(kmsLoggerDataProcessReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        kmsLoggerDataProcessService.enableBatch(kmsLoggerDataProcessReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo) {
        kmsLoggerDataProcessService.disableBatch(kmsLoggerDataProcessReqVo);
        return Result.ok("禁用成功");
    }
}
