package com.biz.crm.grabrule.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.nebular.kms.grabrule.req.KmsDataAuthReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsDataAuthRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 单据数据权限
 * 
 * @author Gavin
 * @date 2021-05-10 15:03:52
 */
public interface KmsDataAuthMapper extends BaseMapper<KmsDataAuthEntity> {
    /**
     * 列表
     * @param page
     * @param kmsDataAuthReqVo
     * @return
     */
    List<KmsDataAuthRespVo> findList(Page<KmsDataAuthRespVo> page, @Param("vo") KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 通过原始数据ID查询数据权限
     * @param rawDataId
     * @return
     */
    KmsDataAuthRespVo findByRawDataId(@Param("rawDataId") String rawDataId);
}
