package com.biz.crm.grabrule.service;

import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.grabrule.resp.KmsDataAuthRespVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsDataAuthReqVo;

import java.util.Map;

/**
 * 单据数据权限接口
 *
 * @author Gavin
 * @date 2021-05-10 15:03:52
 */
public interface IKmsDataAuthService extends IService<KmsDataAuthEntity> {

    /**
     * 列表
     * @param kmsDataAuthReqVo
     * @return PageResult<KmsDataAuthRespVo>
     */
    PageResult<KmsDataAuthRespVo> findList(KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 查询
     * @param kmsDataAuthReqVo
     * @return KmsDataAuthRespVo
     */
    KmsDataAuthRespVo query(KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 新增
     * @param kmsDataAuthReqVo
     * @return
     */
    void save(KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 更新
     * @param kmsDataAuthReqVo
     * @return
     */
    void update(KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 删除
     * @param kmsDataAuthReqVo
     * @return
     */
    void deleteBatch(KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 启用
     * @param kmsDataAuthReqVo
     * @return
     */
    void enableBatch(KmsDataAuthReqVo kmsDataAuthReqVo);

    /**
     * 禁用
     * @param kmsDataAuthReqVo
     * @return
     */
    void disableBatch(KmsDataAuthReqVo kmsDataAuthReqVo);
}

