package com.biz.crm.grabrule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;

/**
 * 抓单规则配置表接口
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
public interface IKmsGrabRuleService extends IService<KmsGrabRuleEntity> {

    /**
     * 列表
     * @param kmsGrabRuleReqVo
     * @return PageResult<KmsGrabRuleRespVo>
     */
    PageResult<KmsGrabRuleRespVo> findList(KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 查询
     * @param kmsGrabRuleReqVo
     * @return KmsGrabRuleRespVo
     */
    KmsGrabRuleRespVo query(KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 新增
     * @param kmsGrabRuleReqVo
     * @return
     */
    void save(KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 更新
     * @param kmsGrabRuleReqVo
     * @return
     */
    void update(KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 删除
     * @param kmsGrabRuleReqVo
     * @return
     */
    void deleteBatch(KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 启用
     * @param kmsGrabRuleReqVo
     * @return
     */
    void enableBatch(KmsGrabRuleReqVo kmsGrabRuleReqVo);

    /**
     * 禁用
     * @param kmsGrabRuleReqVo
     * @return
     */
    void disableBatch(KmsGrabRuleReqVo kmsGrabRuleReqVo);
}

