package com.biz.crm.kaproduct.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.kaproduct.model.KmsProductUnitEntity;
import com.biz.crm.nebular.kms.kaproduct.req.KmsProductUnitReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductUnitRespVo;

/**
 * 企业产品与商超产品单位转换关系表接口
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
public interface IKmsProductUnitService extends IService<KmsProductUnitEntity> {

    /**
     * 列表
     * @param kmsProductUnitReqVo
     * @return PageResult<KmsProductUnitRespVo>
     */
    PageResult<KmsProductUnitRespVo> findList(KmsProductUnitReqVo kmsProductUnitReqVo);

    /**
     * 查询
     * @param kmsProductUnitReqVo
     * @return KmsProductUnitRespVo
     */
    KmsProductUnitRespVo query(KmsProductUnitReqVo kmsProductUnitReqVo);

    /**
     * 新增
     * @param kmsProductUnitReqVo
     * @return
     */
    void save(KmsProductUnitReqVo kmsProductUnitReqVo);

    /**
     * 更新
     * @param kmsProductUnitReqVo
     * @return
     */
    void update(KmsProductUnitReqVo kmsProductUnitReqVo);

    /**
     * 删除
     * @param kmsProductUnitReqVo
     * @return
     */
    void deleteBatch(KmsProductUnitReqVo kmsProductUnitReqVo);

    /**
     * 启用
     * @param kmsProductUnitReqVo
     * @return
     */
    void enableBatch(KmsProductUnitReqVo kmsProductUnitReqVo);

    /**
     * 禁用
     * @param kmsProductUnitReqVo
     * @return
     */
    void disableBatch(KmsProductUnitReqVo kmsProductUnitReqVo);
}

