package com.biz.crm.orderform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderStatusRecordReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderStatusRecordRespVo;
import com.biz.crm.orderform.service.IKmsOrderStatusRecordService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商超订货单状态流转记录表
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Slf4j
@RestController
@RequestMapping("/kmsorderstatusrecord")
//@Api(tags = "商超订货单状态流转记录表")
public class KmsOrderStatusRecordController {
    @Autowired
    private IKmsOrderStatusRecordService kmsOrderStatusRecordService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsOrderStatusRecordRespVo>> list(@RequestBody KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        PageResult<KmsOrderStatusRecordRespVo> result=kmsOrderStatusRecordService.findList(kmsOrderStatusRecordReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsOrderStatusRecordRespVo> query(@RequestBody KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        KmsOrderStatusRecordRespVo respVo=kmsOrderStatusRecordService.query(kmsOrderStatusRecordReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        kmsOrderStatusRecordService.save(kmsOrderStatusRecordReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        kmsOrderStatusRecordService.update(kmsOrderStatusRecordReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        kmsOrderStatusRecordService.deleteBatch(kmsOrderStatusRecordReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        kmsOrderStatusRecordService.enableBatch(kmsOrderStatusRecordReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo) {
        kmsOrderStatusRecordService.disableBatch(kmsOrderStatusRecordReqVo);
        return Result.ok("禁用成功");
    }
}
