package com.biz.crm.rawdata.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.rawdata.service.IKmsInventoryDataFormDetailDwService;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsInventoryDataFormDetailDwReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 库存商超原始单据
 *
 * @author gavin
 * @date 2021-11-24 14:07:31
 */
@Slf4j
@RestController
@RequestMapping("/kmsinventorydataformdetaildw")
@Api(tags = "库存商超原始单据")
public class KmsInventoryDataFormDetailDwController {
    @Autowired
    private IKmsInventoryDataFormDetailDwService kmsInventoryDataFormDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsInventoryDataFormDetailDwRespVo>> list(@RequestBody KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        PageResult<KmsInventoryDataFormDetailDwRespVo> result=kmsInventoryDataFormDetailDwService.findList(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsInventoryDataFormDetailDwRespVo> query(@RequestBody KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        KmsInventoryDataFormDetailDwRespVo respVo=kmsInventoryDataFormDetailDwService.query(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        kmsInventoryDataFormDetailDwService.save(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        kmsInventoryDataFormDetailDwService.update(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        kmsInventoryDataFormDetailDwService.deleteBatch(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        kmsInventoryDataFormDetailDwService.enableBatch(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsInventoryDataFormDetailDwReqVo kmsInventoryDataFormDetailDwReqVo) {
        kmsInventoryDataFormDetailDwService.disableBatch(kmsInventoryDataFormDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
