package com.biz.crm.rawdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.req.KmsOrderFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.rawdata.service.IKmsOrderFormDetailDwService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 原始订单头表
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@RestController
@RequestMapping("/kmsorderformdetaildw")
//@Api(tags = "原始订单头表")
public class KmsOrderFormDetailDwController {
    @Autowired
    private IKmsOrderFormDetailDwService kmsOrderFormDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsOrderFormDetailDwRespVo>> list(@RequestBody KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        PageResult<KmsOrderFormDetailDwRespVo> result=kmsOrderFormDetailDwService.findList(kmsOrderFormDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsOrderFormDetailDwRespVo> query(@RequestBody KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        KmsOrderFormDetailDwRespVo respVo=kmsOrderFormDetailDwService.query(kmsOrderFormDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        kmsOrderFormDetailDwService.save(kmsOrderFormDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        kmsOrderFormDetailDwService.update(kmsOrderFormDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        kmsOrderFormDetailDwService.deleteBatch(kmsOrderFormDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        kmsOrderFormDetailDwService.enableBatch(kmsOrderFormDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo) {
        kmsOrderFormDetailDwService.disableBatch(kmsOrderFormDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
