package com.biz.crm.rawdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.req.KmsReturnGoodsDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnGoodsDetailDwRespVo;
import com.biz.crm.rawdata.service.IKmsReturnGoodsDetailDwService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 原单订单行数据信息
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@RestController
@RequestMapping("/kmsreturngoodsdetaildw")
//@Api(tags = "原单订单行数据信息")
public class KmsReturnGoodsDetailDwController {
    @Autowired
    private IKmsReturnGoodsDetailDwService kmsReturnGoodsDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsReturnGoodsDetailDwRespVo>> list(@RequestBody KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        PageResult<KmsReturnGoodsDetailDwRespVo> result=kmsReturnGoodsDetailDwService.findList(kmsReturnGoodsDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsReturnGoodsDetailDwRespVo> query(@RequestBody KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        KmsReturnGoodsDetailDwRespVo respVo=kmsReturnGoodsDetailDwService.query(kmsReturnGoodsDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        kmsReturnGoodsDetailDwService.save(kmsReturnGoodsDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        kmsReturnGoodsDetailDwService.update(kmsReturnGoodsDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        kmsReturnGoodsDetailDwService.deleteBatch(kmsReturnGoodsDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        kmsReturnGoodsDetailDwService.enableBatch(kmsReturnGoodsDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsReturnGoodsDetailDwReqVo kmsReturnGoodsDetailDwReqVo) {
        kmsReturnGoodsDetailDwService.disableBatch(kmsReturnGoodsDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
