package com.biz.crm.rawdata.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.kms.rawdata.req.KmsOrderFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.rawdata.model.KmsOrderFormDetailDwEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 原始订单头表
 * 
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
public interface KmsOrderFormDetailDwMapper extends BaseMapper<KmsOrderFormDetailDwEntity> {
    /**
     * 列表
     * @param page
     * @param kmsOrderFormDetailDwReqVo
     * @return
     */
    List<KmsOrderFormDetailDwRespVo> findList(Page<KmsOrderFormDetailDwRespVo> page, @Param("vo") KmsOrderFormDetailDwReqVo kmsOrderFormDetailDwReqVo);

    /**
     * 根据订单号查询原始单据
     * @param orderNumbers
     * @return
     */
    List<KmsOrderFormDetailDwRespVo> findByOrderNumbers(@Param("orderNumbers") List<String> orderNumbers);

    /**
     * 自动转换查询待转换数据
     * @param params
     * @return
     */
    List<KmsOrderFormDetailDwRespVo> findNotTransData(@Param("vo") KmsOrderFormDetailDwReqVo params);
}
