package com.biz.crm.returnform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnStatusRecordReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnStatusRecordRespVo;
import com.biz.crm.returnform.service.IKmsReturnStatusRecordService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 退货单状态记录表
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
@Slf4j
@RestController
@RequestMapping("/kmsreturnstatusrecord")
//@Api(tags = "退货单状态记录表")
public class KmsReturnStatusRecordController {
    @Autowired
    private IKmsReturnStatusRecordService kmsReturnStatusRecordService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsReturnStatusRecordRespVo>> list(@RequestBody KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        PageResult<KmsReturnStatusRecordRespVo> result=kmsReturnStatusRecordService.findList(kmsReturnStatusRecordReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsReturnStatusRecordRespVo> query(@RequestBody KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        KmsReturnStatusRecordRespVo respVo=kmsReturnStatusRecordService.query(kmsReturnStatusRecordReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        kmsReturnStatusRecordService.save(kmsReturnStatusRecordReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        kmsReturnStatusRecordService.update(kmsReturnStatusRecordReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        kmsReturnStatusRecordService.deleteBatch(kmsReturnStatusRecordReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        kmsReturnStatusRecordService.enableBatch(kmsReturnStatusRecordReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo) {
        kmsReturnStatusRecordService.disableBatch(kmsReturnStatusRecordReqVo);
        return Result.ok("禁用成功");
    }
}
