package com.biz.crm.returnform.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnFormReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormExportRespVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormRespVo;
import com.biz.crm.returnform.model.KmsReturnFormEntity;

import java.util.List;

/**
 * 退货单信息表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
public interface IKmsReturnFormService extends IService<KmsReturnFormEntity> {

    /**
     * 列表
     *
     * @param kmsReturnFormReqVo
     * @return PageResult<KmsReturnFormRespVo>
     */
    PageResult<KmsReturnFormRespVo> findList(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 查询
     *
     * @param kmsReturnFormReqVo
     * @return KmsReturnFormRespVo
     */
    KmsReturnFormRespVo query(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 新增
     *
     * @param kmsReturnFormReqVo
     * @return
     */
    void save(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 更新
     *
     * @param kmsReturnFormReqVo
     * @return
     */
    void update(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param kmsReturnFormReqVo
     * @return
     */
    void enableBatch(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 禁用
     *
     * @param kmsReturnFormReqVo
     * @return
     */
    void disableBatch(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 手动转换退货单
     *
     * @param kmsReturnFormReqVo
     */
    void manualTrans(KmsReturnFormReqVo kmsReturnFormReqVo);

    /**
     * 自动转换退货单
     *
     * @param dwRespVo
     */
    void autoTransData(KmsReturnFormDetailDwRespVo dwRespVo);

    /**
     * 查询列表导出
     *
     * @param reqVo
     * @return
     */
    PageResult<KmsReturnFormExportRespVo> listForExport(KmsReturnFormReqVo reqVo);
}

