package com.biz.crm.sap.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.sap.req.KmsSapInvoiceReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.mapper.KmsSapInvoiceMapper;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import com.biz.crm.sap.service.IKmsSapInvoiceService;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * SAP发票信息接口实现
 *
 * @author Gavin
 * @date 2021-06-01 17:23:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsSapInvoiceServiceExpandImpl")
public class KmsSapInvoiceServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsSapInvoiceMapper, KmsSapInvoiceEntity> implements IKmsSapInvoiceService {

    @Resource
    private KmsSapInvoiceMapper kmsSapInvoiceMapper;

    /**
     * 根据稽核ID查询关联SAP数据
     * @param auditFormId
     * @return
     */
    @Override
    public List<KmsSapOrderFormRespVo> findByAuditId(String auditFormId) {
        return kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
    }

    /**
     * SAP原始数据列表
     * @param kmsSapOrderFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsSapInvoiceRespVo> findSapInvoicePage(KmsSapInvoiceReqVo params) {
        Page<KmsSapInvoiceRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<KmsSapInvoiceRespVo> list = kmsSapInvoiceMapper.findSapInvoicePage(page, params);
        return PageResult.<KmsSapInvoiceRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }
}
