package com.biz.crm.trans.helper;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.kaproduct.mapper.KmsProductUnitMapper;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalSupplyFeign;
import com.biz.crm.nebular.kms.kaproduct.req.KmsProductUnitReqVo;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductUnitRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsSupplierReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsSupplierRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.supermarket.mapper.KmsSupplierMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.trans.helper
 * @ClassName KmsTransDataHelper
 * @Author Gavin
 * @Date 2021/5/18 下午2:38
 * @Description 数据转换助手
 */
@Slf4j
@Component
public class KmsTransDataHelper {

    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Resource
    private KmsProductUnitMapper kmsProductUnitMapper;

    @Resource
    private MdmTerminalSupplyFeign mdmTerminalSupplyFeign;

    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;

    @Resource
    private MdmCusOrgFeign mdmCusOrgFeign;

    @Resource
    private KmsSupplierMapper kmsSupplierMapper;

    /**
     * 转换门店信息
     *
     * @param transDataVo
     */
    public void transStore(TransDataVo transDataVo) {
        TransDataStoreVo heandVo = transDataVo.getStoreVos();
        //商超门店编码集合
        List<String> kaStoreCodes = Lists.newArrayList();
        List<String> kaStoreNames = Lists.newArrayList();
        //直营体系
        List<String> bsDirectSystemIds = Lists.newArrayList();
        //供应商编码
        List<String> supplierCodes = Lists.newArrayList();

        if (!StringUtils.isEmpty(heandVo.getKaStoreCode())) {
            kaStoreCodes.add(heandVo.getKaStoreCode());
        }
        if (!StringUtils.isEmpty(heandVo.getKaStoreName())) {
            kaStoreNames.add(heandVo.getKaStoreName());
        }
        bsDirectSystemIds.add(heandVo.getBsDirectSystemId());
        supplierCodes.add(heandVo.getSupplierCode());

        //查询商超企业门店关系数据
        KmsTenantryDirectStoreReqVo directStoreReqVo = new KmsTenantryDirectStoreReqVo();
        directStoreReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        directStoreReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        directStoreReqVo.setKaStoreCodes(kaStoreCodes);
        directStoreReqVo.setKaStoreNames(kaStoreNames);
        directStoreReqVo.setBsDirectSystemIdList(bsDirectSystemIds);
        List<KmsTenantryDirectStoreRespVo> directStoreRespVos = kmsTenantryDirectStoreMapper.findStoreAndArea(directStoreReqVo);
        if (CollectionUtils.isEmpty(directStoreRespVos)) {
            heandVo.setOrderStatusMsg("|未查询到与企业门店对应关系");
            return;
        }
        //企业门店编码
        List<String> terminalCodes = Lists.newArrayList();
        //匹配
        List<KmsTenantryDirectStoreRespVo> kaStoreList = matchDirectStore(heandVo, directStoreRespVos);
        if (CollectionUtils.isEmpty(kaStoreList)) {
            heandVo.setOrderStatusMsg("|未匹配到与企业门店对应关系");
        } else if (kaStoreList.size() > 1) {
            heandVo.setOrderStatusMsg("|商超门店存在多个对应关系");
        } else {
            KmsTenantryDirectStoreRespVo vo = kaStoreList.get(0);
            heandVo.setKaCode(vo.getBsDirectSystemCode());
            heandVo.setStoreCode(vo.getTerminalCode());
            heandVo.setStoreName(vo.getTerminalName());
            terminalCodes.add(vo.getTerminalCode());
            heandVo.setStoreRelatedId(vo.getId());
            heandVo.setTimeOfDay(vo.getTimeOfDay());
        }

        //查询企业门店信息
        MdmTerminalSupplyVo supplyVo = new MdmTerminalSupplyVo();
        supplyVo.setTerminalCodeList(terminalCodes);
        List<MdmCustomerRespVo> customerRespVos = ApiResultUtil.objResult(mdmTerminalSupplyFeign.findBySupply(supplyVo));
        if (CollectionUtils.isEmpty(customerRespVos)) {
            customerRespVos = Lists.newArrayList();
        }
        Map<String, List<MdmCustomerRespVo>> customerMap = customerRespVos.stream()
                .collect(Collectors.groupingBy(MdmCustomerRespVo::getTerminalCode));
        //查询直营体系所属客户组织
        List<KmsTenantryDirectCustomerOrgEntity> kmsTenantryDirectCustomerOrgEntities =
                CollectionUtils.isEmpty(bsDirectSystemIds) ? Lists.newArrayList() : kmsTenantryDirectCustomerOrgMapper.selectBatchIds(bsDirectSystemIds);
        List<String> customerOrgIds = Lists.newArrayList();
        Map<String, String> bsCustOrgMap = Maps.newHashMap();
        kmsTenantryDirectCustomerOrgEntities.forEach(bs -> {
            customerOrgIds.add(bs.getCustomerOrgId());
            bsCustOrgMap.put(bs.getId(), bs.getCustomerOrgCode());
        });
        //查询客户组织信息
        CusOrgVo cusOrgVo = new CusOrgVo();
        cusOrgVo.setIds(customerOrgIds);
        List<CusOrgVo> cusOrgVos = ApiResultUtil.objResult(mdmCusOrgFeign.findList(cusOrgVo));
        if (CollectionUtils.isEmpty(cusOrgVos)) {
            cusOrgVos = Lists.newArrayList();
        }
        Map<String, CusOrgVo> cusOrgVoMap = cusOrgVos.stream()
                .collect(Collectors.toMap(CusOrgVo::getCustomerOrgCode, Function.identity()));
        //查询供应商与售达方的对应关系
        KmsSupplierReqVo supplierReqVo = new KmsSupplierReqVo();
        supplierReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        supplierReqVo.setSupplierCodes(supplierCodes);
        supplierReqVo.setBsDirectSystemIdList(bsDirectSystemIds);
        List<KmsSupplierRespVo> mapperList = kmsSupplierMapper.findList(supplierReqVo);
        Map<String, KmsSupplierRespVo> supplierRespVoMap = mapperList.stream()
                .collect(Collectors.toMap(s -> s.getBsDirectSystemId() + "-" + s.getSupplierCode(), Function.identity()));
        String bsDirectSystemId = heandVo.getBsDirectSystemId();
        String storeCode = heandVo.getStoreCode();
        List<MdmCustomerRespVo> mdmCustomerList = customerMap.get(storeCode);
        //判断是否存在供应商
        if (!StringUtils.isEmpty(heandVo.getSupplierCode())) {
            String key = bsDirectSystemId + "-" + heandVo.getSupplierCode();
            KmsSupplierRespVo kmsSupplierRespVo = supplierRespVoMap.get(key);
            if (!ObjectUtils.isEmpty(kmsSupplierRespVo)) {
                heandVo.setSoldToPartyCode(kmsSupplierRespVo.getSellPartyCode());
            }
        }
        if (CollectionUtils.isEmpty(mdmCustomerList)) {
            heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|未匹配售达方信息！");
        } else {
            if (!StringUtils.isEmpty(heandVo.getSoldToPartyCode())) {
                mdmCustomerList = mdmCustomerList.stream()
                        .filter(e -> e.getCustomerCode().equals(heandVo.getSoldToPartyCode()))
                        .collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(mdmCustomerList)) {
                heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|未匹配售达方信息！");
            } else if (mdmCustomerList.size() > 1) {
                heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|终端门店[" + storeCode + "]找到多个售达方");
            } else {
                MdmCustomerRespVo mdmCustomerRespVo = mdmCustomerList.get(0);
                heandVo.setSoldToPartyCode(mdmCustomerRespVo.getCustomerCode());
                heandVo.setSoldToPartyName(mdmCustomerRespVo.getCustomerName());
                heandVo.setChannel(mdmCustomerRespVo.getChannel());
            }
        }
        //客户组织
        String cusOrgCode = bsCustOrgMap.get(bsDirectSystemId);
        CusOrgVo cusOrg = cusOrgVoMap.get(cusOrgCode);
        if (!ObjectUtils.isEmpty(cusOrg)) {
            heandVo.setCustomerOrgCode(cusOrg.getCustomerOrgCode());
            heandVo.setCustomerOrgType(cusOrg.getCustomerOrgType());
        } else {
            heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|未找到客户组织");
        }
        transDataVo.setStoreVos(heandVo);
    }

    /**
     * 噻选直营门店
     *
     * @param o
     * @param directStoreRespVos
     * @return
     */
    private List<KmsTenantryDirectStoreRespVo> matchDirectStore(TransDataStoreVo tstore, List<KmsTenantryDirectStoreRespVo> directStoreRespVos) {
        List<KmsTenantryDirectStoreRespVo> kaStoreList = null;
        //判断商超编码是否为空
        String kaStoreCode = tstore.getKaStoreCode();
        //供应商
        String supplierCode = tstore.getSupplierCode();
        String kaName = tstore.getKaName();
        if (!StringUtils.isEmpty(kaStoreCode)) {
            kaStoreList = directStoreRespVos.stream()
                    .filter(s -> s.getStoreCode().equals(kaStoreCode) && s.getBsDirectSystemName().equals(kaName))
                    .collect(Collectors.toList());
            //二次区域过滤
            kaStoreList = areaFilter(tstore, kaStoreList);
        } else {
            String ksStoreName = tstore.getKaStoreName();
            //商超编码为空就以商超名称为准
            kaStoreList = directStoreRespVos.stream()
                    .filter(s -> s.getStoreName().equals(ksStoreName) && s.getBsDirectSystemName().equals(kaName))
                    .collect(Collectors.toList());
            //二次区域过滤
            kaStoreList = areaFilter(tstore, kaStoreList);
        }
        //size大于1在通过供应商过滤
        if (!StringUtils.isEmpty(supplierCode) && !CollectionUtils.isEmpty(kaStoreList) && kaStoreList.size() > 1) {
            return kaStoreList.stream().filter(o -> supplierCode.equals(o.getExt1())).collect(Collectors.toList());
        }
        return kaStoreList;
    }

    /**
     * 二次区域过滤
     *
     * @param o
     * @param kaStoreList
     * @return
     */
    private List<KmsTenantryDirectStoreRespVo> areaFilter(TransDataStoreVo tstore, List<KmsTenantryDirectStoreRespVo> kaStoreList) {
        //商超订单区域
        String areaCode = tstore.getAreaCode();
        String areaName = tstore.getAreaName();
        if (!StringUtils.isEmpty(areaCode)) {
            List<KmsTenantryDirectStoreRespVo> collect = kaStoreList.stream()
                    .filter(s -> areaCode.equals(s.getAreaCode())).collect(Collectors.toList());
            if (collect.size() > 1 && !StringUtils.isEmpty(areaName)) {
                return collect.stream().filter(s -> areaName.equals(s.getAreaName())).collect(Collectors.toList());
            } else {
                return collect;
            }
        } else if (!StringUtils.isEmpty(areaName)) {
            return kaStoreList.stream()
                    .filter(s -> areaName.equals(s.getAreaName())).collect(Collectors.toList());
        } else {
            return kaStoreList;
        }
    }

    /**
     * 转换商品信息
     *
     * @param transDataVo
     */
    public void transGoods(TransDataVo transDataVo) {
        TransDataStoreVo heandVo = transDataVo.getStoreVos();
        //商超商品编码查询商超商品与企业产品对应关系
        List<String> kaGoodsCodes = transDataVo.getGoodsVos().stream().map(TransDataGoodsVo::getKaGoodsCode)
                .distinct().collect(Collectors.toList());
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        params.setKaProductCodes(kaGoodsCodes);
        params.setBsDirectSystemId(heandVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> directProductRespVos = kmsTenantryDirectProductMapper
                .findList(params);
        if (CollectionUtils.isEmpty(directProductRespVos)) {
            transDataVo.getGoodsVos().forEach(o -> {
                o.setOrderStatusMsg("|未查询到与企业商品对应关系");
            });
            return;
        }
        List<String> productIds = new ArrayList<>();
        //组织处理获取公司层级
        directProductRespVos.forEach(o -> {
            o.setCreateOrgCode(KmsOrgUtil.getCompanyOrgCode(o.getCreateOrgCode()));
            productIds.add(o.getId());
        });
        //查询商品单位
        KmsProductUnitReqVo unitReqVo = new KmsProductUnitReqVo();
        unitReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        unitReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        unitReqVo.setOrderType(transDataVo.getOrderType());
        unitReqVo.setTenantryDirectProductIds(productIds);
        List<KmsProductUnitRespVo> unitRespVos = kmsProductUnitMapper.findList(unitReqVo);
        //关系ID + 商超单位分组
        Map<String, List<KmsProductUnitRespVo>> unitMap = unitRespVos.stream()
                .collect(Collectors.groupingBy(o -> o.getTenantryDirectProductId() + "_" + o.getKaUnitCode()));
        //根据商超商品编码
        Map<String, List<KmsTenantryDirectProductRespVo>> kaStoreMap = directProductRespVos.stream()
                .collect(Collectors.groupingBy(o -> o.getKaProductCode()));
        //循环匹配
        transDataVo.getGoodsVos().forEach(o -> {
            //获取售达方
            String orderNumber = o.getOrderNumber();
            String soldToPartyCode = heandVo.getSoldToPartyCode();
            //获取商品信息根据ka商品编码+售达方
            String key = o.getKaGoodsCode();
            List<KmsTenantryDirectProductRespVo> productRespVos = kaStoreMap.get(key);
            if (CollectionUtils.isEmpty(productRespVos)) {
                o.setOrderStatusMsg("|未查询到与企业商品对应关系");
            } else {
                productRespVos = productRespVos.stream()
                        .filter(s -> s.getSellPartyCode().equals(soldToPartyCode)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(productRespVos)) {
                    o.setOrderStatusMsg("|售达方[" + soldToPartyCode + "]未查询到与企业商品对应关系");
                } else {
                    //获取单据日期所属星期
                    String week = StringUtils.isEmpty(o.getOrderDate()) ? "" : DateUtil.getWeek(o.getOrderDate());
                    List<KmsTenantryDirectProductRespVo> weekFilterList = productRespVos.stream()
                            .filter(goods -> ObjectUtils.isEmpty(goods.getTimeOfWeek()) || goods.getTimeOfWeek().toString().equals(week))
                            .collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(weekFilterList)) {
                        o.setOrderStatusMsg("|未匹配到与企业商品对应关系");
                    } else if (weekFilterList.size() > 1) {
                        o.setOrderStatusMsg("|企业商品存在多个对应关系");
                    } else {
                        KmsTenantryDirectProductRespVo vo = weekFilterList.get(0);
                        o.setGoodsCode(vo.getProductCode());
                        o.setGoodsName(vo.getProductName());
                        o.setGoodsRelatedId(vo.getId());
                        //单位换算
                        if (!StringUtils.isEmpty(o.getCurUnit())) {
                            String unitKey = vo.getId() + "_" + o.getCurUnit();
                            List<KmsProductUnitRespVo> unitRespList = unitMap.get(unitKey);
                            if (ObjectUtils.isEmpty(unitRespList)) {
                                o.setOrderStatusMsg("|未匹配企业商品单位转换关系");
                            } else if (unitRespList.size() > 1) {
                                o.setOrderStatusMsg("|存在多个企业商品单位转换关系");
                            } else {
                                KmsProductUnitRespVo unitRespVo = unitRespList.get(0);
                                //分子
                                BigDecimal numerator = ObjectUtils.isEmpty(unitRespVo.getNumerator())
                                        ? BigDecimal.ONE : unitRespVo.getNumerator();
                                o.setNumerator(numerator);
                                //分母
                                BigDecimal ratio = unitRespVo.getRatio();
                                o.setRatio(ratio);
                                //除法
                                o.setCurCompanyUnit(unitRespVo.getUnitCode());
                                String curUnitOrderQuantity = o.getCurUnitOrderQuantity();
                                if (StringUtils.isEmpty(curUnitOrderQuantity)) {
                                    o.setOrderStatusMsg("|商超单位数量错误");
                                } else {
                                    BigDecimal kaUnitQuantity = new BigDecimal(curUnitOrderQuantity);
                                    BigDecimal companyUnitQuantity = kaUnitQuantity.multiply(numerator)
                                            .divide(ratio, 6, BigDecimal.ROUND_HALF_UP);
                                    o.setCurCompanyUnitOrderQuantity(companyUnitQuantity.toString());
                                }
                            }
                        } else {
                            o.setCurCompanyUnitOrderQuantity(o.getCurUnitOrderQuantity());
                        }
                    }
                }
            }
        });
    }
}