package com.biz.crm.trans.service.impl;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.biz.crm.trans.helper.KmsTransDataHelper;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataVo;

import lombok.extern.slf4j.Slf4j;

/**
 * @Project crm
 * @PackageName com.biz.crm.trans.service.impl
 * @ClassName KmsTransDataServiceImpl
 * @Author Gavin
 * @Date 2021/5/18 下午2:33
 * @Description 单据数据转换实现
 */
@Slf4j
@Service
public class KmsTransDataServiceImpl implements IKmsTransDataService {

    @Resource
    private KmsTransDataHelper kmsTransDataHelper;

    /**
     * 数据转换
     * @param transDataVo
     */
    @Override
    public void transData(TransDataVo transDataVo) {
        //转换门店信息
        kmsTransDataHelper.transStore(transDataVo);
        //转换商品信息
        kmsTransDataHelper.transGoods(transDataVo);
    }
}