package com.biz.crm.util;

import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.constant.KmsConstant;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName KmsUtils
 * @Author Gavin
 * @Date 2021/6/16 上午9:28
 * @Description 抓单工具类
 */
public class KmsUtils {

    /**
     * 清除字符串前面得零
     */
    public static String removeFrontZero(String str) {
        return str.replaceAll("^(0+)", "");
    }

    /**
     * 过滤字段
     */
    public static String[] ignoreProperties() {
        List<String> collect = Arrays.stream(CrmBaseEntity.class.getDeclaredFields())
                .map(Field::getName)
                .collect(Collectors.toList());
        collect.add("id");
        String[] ignoreProperties = collect.toArray(new String[]{});
        return ignoreProperties;
    }

    /**
     * 加零
     *
     * @param str
     * @return
     */
    public static String addZero(String str, int flag) {
        int length = str.length();
        String zero = "";
        for (int i = 0, j = flag - length; i < j; i++) {
            zero += "0";
        }
        str = zero + str;
        return str;
    }

    /**
     * 获取稽核条件枚举
     *
     * @param templateReqVo
     * @return
     */
    public static KmsAuditConditionEnum getConditionEnum(KmsAuditTemplateRespVo templateRespVo) {
        //门店+日期+商品
        List<String> stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_TIME.getValue());
        stp.add(KmsAdminEnum.AuditCondition.GOODS_CODE.getValue());
        String aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.PDS;
        }
        //门店+商品+订单
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.GOODS_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_CODE.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.PDSO;
        }
        //门店+日期
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_TIME.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.DS;
        }
        //门店+订单
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_CODE.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.PDSO;
        }
        return null;
    }

    /**
     * 获取稽核单据
     *
     * @param templateReqVo
     * @return
     */
    public static String getOrderTypeConEnum(KmsAuditTemplateRespVo templateRespVo) {
        //验收单
        List<String> stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.OrderType.ACCEPTANCE.getValue());
        String aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getOrderTypeArray())) {
            return KmsEnum.AuditOrderType.ACCEPTANCE.getValue();
        }
        //定货单+验收单
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.OrderType.ORDER.getValue());
        stp.add(KmsAdminEnum.OrderType.ACCEPTANCE.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getOrderTypeArray())) {
            return KmsEnum.AuditOrderType.ORDER_ACCEPTANCE.getValue();
        }
        return null;
    }

    /**
     * 验收单数据处理
     *
     * @param a
     * @param taxRate
     */
    public static void acceptanceAmountHandle(KmsAuditAcceptanceFormRespVo a, BigDecimal taxRate) {
        //验收金额含税
        BigDecimal acceptanceAmount = BigDecimal.ZERO;
        //验收金额不含税
        BigDecimal acceptanceAmountNot = BigDecimal.ZERO;
        if (!StringUtils.isEmpty(a.getAcceptanceAmount())
                && (StringUtils.isEmpty(a.getAcceptanceAmountNot())
                || new BigDecimal(a.getAcceptanceAmountNot()).compareTo(BigDecimal.ZERO) == 0) && !ObjectUtils.isEmpty(taxRate)) {
            acceptanceAmount = new BigDecimal(a.getAcceptanceAmount());
            acceptanceAmountNot = acceptanceAmount.divide(taxRate, 6, BigDecimal.ROUND_HALF_UP);
        } else if ((StringUtils.isEmpty(a.getAcceptanceAmount()) || new BigDecimal(a.getAcceptanceAmount()).compareTo(BigDecimal.ZERO) == 0)
                && !StringUtils.isEmpty(a.getAcceptanceAmountNot()) && !ObjectUtils.isEmpty(taxRate)) {
            acceptanceAmountNot = new BigDecimal(a.getAcceptanceAmountNot());
            acceptanceAmount = acceptanceAmountNot.multiply(taxRate);
        } else if (!StringUtils.isEmpty(a.getAcceptanceAmount()) && !StringUtils.isEmpty(a.getAcceptanceAmountNot())) {
            acceptanceAmount = new BigDecimal(a.getAcceptanceAmount());
            acceptanceAmountNot = new BigDecimal(a.getAcceptanceAmountNot());
        }
        a.setAcceptanceAmount(acceptanceAmount.toString());
        a.setAcceptanceAmountNot(acceptanceAmountNot.toString());
        //验收数量
        BigDecimal acceptanceQuantity = StringUtils.isEmpty(a.getAcceptanceQuantity()) ? BigDecimal.ZERO : new BigDecimal(a.getAcceptanceQuantity());
        a.setAcceptanceQuantity(acceptanceQuantity.toString());
    }

    /**
     * 验收关系表
     *
     * @param o
     * @param auditId
     * @param templateId
     */
    public static KmsAcceptanceMatchRelationEntity buildAcceptanceMatchRelation(KmsAuditAcceptanceFormRespVo o, KmsAuditFormRespVo afVo, String templateId) {
        KmsAcceptanceMatchRelationEntity relationEntity = new KmsAcceptanceMatchRelationEntity();
        relationEntity.setAuditId(afVo.getId());
        relationEntity.setAuditNumber(afVo.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setHeaderId(o.getHeaderId());
        relationEntity.setRelationId(o.getId());
        return relationEntity;
    }

    /**
     * 匹配金额处理
     *
     * @param o
     */
    public static void sapInvoiceData(KmsAuditFormRespVo o) {
        o.setSapAmount(BigDecimal.ZERO);
        o.setSapAmountNot(BigDecimal.ZERO);
        o.setSapQuantity(BigDecimal.ZERO);
        o.setAcceptanceAmount(BigDecimal.ZERO);
        o.setAcceptanceAmountNot(BigDecimal.ZERO);
        o.setAcceptanceQuantity(BigDecimal.ZERO);
        o.setCompareAmount(BigDecimal.ZERO);
        o.setCompareAmountNot(BigDecimal.ZERO);
        o.setCompareQuantity(BigDecimal.ZERO);
        Map<String, BigDecimal> taxRateMap = Maps.newHashMap();
        //SAP数据汇总处理
        o.getSapOrderFormVos().forEach(s -> {
            //含税 稽核系统里“SAP总金额”含税=KZWI1+YK11+ZST2
            s.setSapAmount(s.getKzwi1().add(s.getYk11()).add(s.getZst2()));
            o.setSapAmount(o.getSapAmount().add(s.getSapAmount()));
            //不含税 稽核系统里“SAP总金额”不含税=NETWR+（YK11+ZST2）/（1+MWSI1/1000）
            BigDecimal numerator = s.getYk11().add(s.getZst2());
            BigDecimal denominator = BigDecimal.ONE.add(s.getMwsi1().divide(KmsConstant.BASE_1000));
            s.setSapAmountNot(s.getNetwr().add(numerator.divide(denominator, 6, BigDecimal.ROUND_HALF_UP)));
            o.setSapAmountNot(o.getSapAmountNot().add(s.getSapAmountNot()));
            s.setSapMaterielCode(removeFrontZero(s.getSapMaterielCode()));
            taxRateMap.put(s.getSapMaterielCode(), denominator);
            //数量
            o.setSapQuantity(o.getSapQuantity().add(s.getSapQuantity()));
            //单价处理
            s.setDanjia(s.getSapAmount().divide(s.getSapQuantity(), 2, BigDecimal.ROUND_HALF_UP));
        });
        //单价处理
        if (!ObjectUtils.isEmpty(o.getSapQuantity()) && o.getSapQuantity().compareTo(BigDecimal.ZERO) != 0) {
            o.setDanjia(o.getSapAmount().divide(o.getSapQuantity(), 2, BigDecimal.ROUND_HALF_UP));
        }

        //含税价格差值
        BigDecimal sub = BigDecimal.ZERO;
        //不含税价格差值
        BigDecimal subNot = BigDecimal.ZERO;
        //数量差额
        BigDecimal subQuantity = BigDecimal.ZERO;
        //处理验收单数据
        if (CollectionUtils.isEmpty(o.getAcceptanceFormVos())) {
            o.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
            o.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
            //含税价格差值
            sub = o.getAcceptanceAmount().subtract(o.getSapAmount());
            //不含税价格差值
            subNot = o.getAcceptanceAmountNot().subtract(o.getSapAmountNot());
            //数量差额
            subQuantity = o.getAcceptanceQuantity().subtract(o.getSapQuantity());
        } else {
            o.getAcceptanceFormVos().forEach(acc -> {
                //税率
                BigDecimal taxRate = taxRateMap.get(acc.getGoodsCode());
                acceptanceAmountHandle(acc, taxRate);
                o.setAcceptanceQuantity(o.getAcceptanceQuantity().add(new BigDecimal(acc.getAcceptanceQuantity())));
                o.setAcceptanceAmount(o.getAcceptanceAmount().add(new BigDecimal(acc.getAcceptanceAmount())));
                o.setAcceptanceAmountNot(o.getAcceptanceAmountNot().add(new BigDecimal(acc.getAcceptanceAmountNot())));
            });
            //价格允差，类型
            String auditRule = o.getAuditRule();
            BigDecimal differencePrice = o.getDifferencePrice();
            //含税价格差值
            sub = o.getAcceptanceAmount().subtract(o.getSapAmount());
            BigDecimal priceDiff = sub.multiply(new BigDecimal(-1));
            //不含税价格差值
            subNot = o.getAcceptanceAmountNot().subtract(o.getSapAmountNot());
            //数量差额
            subQuantity = o.getAcceptanceQuantity().subtract(o.getSapQuantity());
            if (subQuantity.compareTo(BigDecimal.ZERO) != 0) {
                if (KmsEnum.AuditRule.Z.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_QUANTITY_DIFF.getValue());
                    }
                } else if (KmsEnum.AuditRule.F.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_QUANTITY_DIFF.getValue());
                    }
                } else if (KmsEnum.AuditRule.UD.getValue().equals(auditRule)) {
                    if ((priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0) ||
                            (priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0)) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_QUANTITY_DIFF.getValue());
                    }
                }
                if (KmsEnum.AuditResult.NO_DIFFERENCE.getValue().equals(o.getAuditResult())) {
                    o.setAuditResult(KmsEnum.AuditResult.QUANTITY_DIFF.getValue());
                }
            } else {
                if (KmsEnum.AuditRule.Z.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_DIFF.getValue());
                    }
                } else if (KmsEnum.AuditRule.F.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_DIFF.getValue());
                    }
                } else if (KmsEnum.AuditRule.UD.getValue().equals(auditRule)) {
                    if ((priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0) ||
                            (priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0)) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_DIFF.getValue());
                    }
                }
            }
        }
        o.setCompareAmount(ObjectUtils.isEmpty(sub) ? BigDecimal.ZERO : sub);
        o.setCompareAmountNot(ObjectUtils.isEmpty(subNot) ? BigDecimal.ZERO : subNot);
        o.setCompareQuantity(ObjectUtils.isEmpty(subQuantity) ? BigDecimal.ZERO : subQuantity);
    }

    /**
     * 设置保留两位小数
     *
     * @param o
     */
    public static void setScaleTwo(KmsAuditFormRespVo o) {
        if (!ObjectUtils.isEmpty(o.getAcceptanceAmountNot())) {
            o.setAcceptanceAmountNot(o.getAcceptanceAmountNot().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (!ObjectUtils.isEmpty(o.getAcceptanceAmount())) {
            o.setAcceptanceAmount(o.getAcceptanceAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (!ObjectUtils.isEmpty(o.getSapAmount())) {
            o.setSapAmount(o.getSapAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (!ObjectUtils.isEmpty(o.getSapAmountNot())) {
            o.setSapAmountNot(o.getSapAmountNot().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (!ObjectUtils.isEmpty(o.getCompareAmount())) {
            o.setCompareAmount(o.getCompareAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (!ObjectUtils.isEmpty(o.getCompareAmountNot())) {
            o.setCompareAmountNot(o.getCompareAmountNot().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (!CollectionUtils.isEmpty(o.getSapOrderFormVos())) {
            o.getSapOrderFormVos().forEach(s -> {
                if (!ObjectUtils.isEmpty(s.getSapAmount())) {
                    s.setSapAmount(s.getSapAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
                }
                if (!ObjectUtils.isEmpty(s.getSapAmountNot())) {
                    s.setSapAmountNot(s.getSapAmountNot().setScale(2, BigDecimal.ROUND_HALF_UP));
                }
            });
        }
        if (!CollectionUtils.isEmpty(o.getAcceptanceFormVos())) {
            o.getAcceptanceFormVos().forEach(a -> {
                a.setAcceptanceAmount(new BigDecimal(a.getAcceptanceAmount()).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
                a.setAcceptanceAmountNot(new BigDecimal(a.getAcceptanceAmountNot()).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            });
        }
    }

    /**
     * 重新赋值
     *
     * @param afVo
     * @param auditFormEntity
     */
    public static void updateAuditFormData(KmsAuditFormRespVo afVo, KmsAuditFormEntity auditFormEntity) {
        auditFormEntity.setSapAmount(afVo.getSapAmount().toString());
        auditFormEntity.setSapAmountNot(afVo.getSapAmountNot().toString());
        auditFormEntity.setSapQuantity(afVo.getSapQuantity().toString());
        auditFormEntity.setAcceptanceAmount(afVo.getAcceptanceAmount().toString());
        auditFormEntity.setAcceptanceAmountNot(afVo.getAcceptanceAmountNot().toString());
        auditFormEntity.setAcceptanceQuantity(afVo.getAcceptanceQuantity().toString());
        auditFormEntity.setCompareAmount(afVo.getCompareAmount().toString());
        auditFormEntity.setCompareAmountNot(afVo.getCompareAmountNot().toString());
        auditFormEntity.setCompareQuantity(afVo.getCompareQuantity().toString());
        auditFormEntity.setAuditResult(afVo.getAuditResult());
    }

    /**
     * yyyy-MM-dd to yyyyMMdd
     *
     * @param auditDate
     * @return
     */
    public static String formatYYYYMMDD(String auditDate) {
        Date dateByFormat = DateUtil.getDateByFormat(auditDate, DateUtil.DEFAULT_DATE_FORMAT);
        return DateUtil.format(dateByFormat, DateUtil.DEFAULT_MONTH_DAY_PATTERN);
    }

    /**
     * 获取异常信息
     *
     * @param stackTraceElements
     * @param filtration
     * @return
     */
    public static String errorString(StackTraceElement[] stackTraceElements, String filtration) {
        if (null == stackTraceElements || stackTraceElements.length < 1) {
            return null;
        }
        StringBuffer upMethodName = new StringBuffer();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(filtration)) {
                if (!stackTraceElement.getClassName().startsWith(filtration)) {
                    continue;
                }
            }
            upMethodName.append("\n\t res ");
            upMethodName.append(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
        }

        return upMethodName.toString();
    }
}