package com.biz.crm.webservice.order.req;

import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.webservice.NameSpace;
import lombok.Builder;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * @Project dmp-platform
 * @PackageName cn.linglong.dmp.common.vo.webservice.envelope
 * @ClassName QueryNoCompensationReqVo
 * @Author Gavin
 * @Date 2020/6/29 6:17 下午
 * @Description 查询CRM胎号冻结
 */
@XmlRootElement(name = "Envelope",namespace = NameSpace.XMLNS_SOAP)
@XmlType(name = "KmsOrderFormPushSapReqVo",propOrder = {"header","body"})
public class KmsOrderFormPushSapReqVo {

    @XmlElement(name = "Header",namespace = NameSpace.XMLNS_SOAP)
    private String header;

    @XmlElement(name = "Body",namespace = NameSpace.XMLNS_SOAP)
    private KmsOrderFormPushSapBodyReqVo body;

    @XmlTransient
    public KmsOrderFormPushSapBodyReqVo getBody() {
        return body;
    }

    public void setBody(KmsOrderFormPushSapBodyReqVo body) {
        this.body = body;
    }

    @XmlTransient
    public String getHeader() {
        return header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public KmsOrderFormPushSapReqVo(){
        super();
    }

    @Builder
    public KmsOrderFormPushSapReqVo(KmsOrderFormRespVo kmsOrderFormRespVo){
        this.header = "";
        this.body = KmsOrderFormPushSapBodyReqVo.builder().kmsOrderFormRespVo(kmsOrderFormRespVo).build();
    }
}