/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.acceptanceform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acceptanceform.helper.KmsAcceptanceFormHelper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceGoodsMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceFormService;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceGoodsService;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.service.IKmsDirectStoreAreaService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.finance.mapper.KmsAcceptanceMatchRelationMapper;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormExportRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceGoodsRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAcceptanceMatchRelationRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.rawdata.mapper.KmsAcceptanceFormDetailDwMapper;
import com.biz.crm.rawdata.mapper.KmsAcceptanceGoodsDetailDwMapper;
import com.biz.crm.rawdata.model.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.soap.SOAPException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsAcceptanceFormServiceExpandImpl"})
public class KmsAcceptanceFormServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsAcceptanceFormMapper, KmsAcceptanceFormEntity>
implements IKmsAcceptanceFormService {
    private static final Logger log = LoggerFactory.getLogger(KmsAcceptanceFormServiceImpl.class);
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private KmsAcceptanceGoodsMapper kmsAcceptanceGoodsMapper;
    @Resource
    private IKmsAcceptanceGoodsService kmsAcceptanceGoodsService;
    @Resource
    private KmsAcceptanceFormHelper kmsAcceptanceFormHelper;
    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;
    @Resource
    private KmsAcceptanceMatchRelationMapper kmsAcceptanceMatchRelationMapper;
    @Resource
    private IKmsAuditFormService kmsAuditFormService;
    @Resource
    private KmsAcceptanceFormDetailDwMapper kmsAcceptanceFormDetailDwMapper;
    @Resource
    private KmsAcceptanceGoodsDetailDwMapper kmsAcceptanceGoodsDetailDwMapper;
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;
    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;
    @Resource
    private IKmsDirectStoreAreaService kmsDirectStoreAreaService;

    @Override
    public PageResult<KmsAcceptanceFormRespVo> findList(KmsAcceptanceFormReqVo reqVo) {
        Page page;
        List<KmsAcceptanceFormRespVo> list;
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(list = this.kmsAcceptanceFormMapper.findList((Page<KmsAcceptanceFormRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            List orderNumber = list.stream().map(KmsAcceptanceFormRespVo::getOrderNumber).collect(Collectors.toList());
            List goodsEntities = ((LambdaQueryChainWrapper)this.kmsAcceptanceGoodsService.lambdaQuery().in(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber)).list();
            Map<String, List<KmsAcceptanceGoodsEntity>> goodsMap = goodsEntities.stream().collect(Collectors.groupingBy(KmsAcceptanceGoodsEntity::getOrderNumber));
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            List<String> ids = list.stream().map(KmsAcceptanceFormRespVo::getStoreRelatedId).distinct().collect(Collectors.toList());
            List<KmsAcceptanceFormRespVo> nameList = this.kmsAcceptanceFormMapper.findAreaName(ids);
            Map<String, List<KmsAcceptanceFormRespVo>> nameMap = nameList.stream().collect(Collectors.groupingBy(UuidVo::getId));
            this.setData(list, goodsMap, orgCompanyMap, nameMap);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<KmsAcceptanceFormExportRespVo> listForExport(KmsAcceptanceFormReqVo reqVo) {
        Page page;
        List<KmsAcceptanceFormExportRespVo> list;
        AssertUtils.isNotEmpty((String)reqVo.getAcceptanceDateStart(), (String)"\u9a8c\u6536\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getAcceptanceDateEnd(), (String)"\u9a8c\u6536\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(list = this.kmsAcceptanceFormMapper.findListForExport((Page<KmsAcceptanceFormExportRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            List orderNumber = list.stream().map(KmsAcceptanceFormRespVo::getOrderNumber).collect(Collectors.toList());
            List goodsEntities = ((LambdaQueryChainWrapper)this.kmsAcceptanceGoodsService.lambdaQuery().in(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber)).list();
            Map<String, List<KmsAcceptanceGoodsEntity>> goodsMap = goodsEntities.stream().collect(Collectors.groupingBy(KmsAcceptanceGoodsEntity::getOrderNumber));
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> {
                o.setFinalAcceptanceAmount(BigDecimal.ZERO.toString());
                List entities = (List)goodsMap.get(o.getOrderNumber());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)entities)) {
                    entities.forEach(e -> {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)e.getAcceptanceAmount())) {
                            o.setFinalAcceptanceAmount(new BigDecimal(o.getFinalAcceptanceAmount()).add(new BigDecimal(e.getAcceptanceAmount())).toString());
                        }
                    });
                }
                o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsAcceptanceFormRespVo query(KmsAcceptanceFormReqVo reqVo) {
        String id = reqVo.getId();
        AssertUtils.isNotEmpty((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsAcceptanceFormEntity acceptanceFormEntity = (KmsAcceptanceFormEntity)this.kmsAcceptanceFormMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)acceptanceFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        KmsAcceptanceFormRespVo formRespVo = (KmsAcceptanceFormRespVo)CrmBeanUtil.copy((Object)acceptanceFormEntity, KmsAcceptanceFormRespVo.class);
        String orderNumber = formRespVo.getOrderNumber();
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsAcceptanceGoodsEntity::getOrderNumber, (Object)orderNumber);
        List goodsEntities = this.kmsAcceptanceGoodsMapper.selectList((Wrapper)build);
        formRespVo.setAcceptanceGoodsVos(CrmBeanUtil.copyList((List)goodsEntities, KmsAcceptanceGoodsRespVo.class));
        return formRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsAcceptanceFormReqVo reqVo) {
        KmsAcceptanceFormEntity entity = (KmsAcceptanceFormEntity)CrmBeanUtil.copy((Object)reqVo, KmsAcceptanceFormEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsAcceptanceFormReqVo reqVo) {
        KmsAcceptanceFormEntity entity = (KmsAcceptanceFormEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsAcceptanceFormReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)CommonException.IDS_NULL.getDescription());
        List kmsAcceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(reqVo.getIds());
        List kmsAcceptanceFormDetailDwEntities = this.kmsAcceptanceFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isEmpty((Collection)kmsAcceptanceFormEntities)) {
            return;
        }
        Set orderNumberSet = kmsAcceptanceFormEntities.stream().map(KmsAcceptanceFormEntity::getOrderNumber).collect(Collectors.toSet());
        this.removeByIds(orderNumberSet);
        this.kmsAcceptanceFormDetailDwMapper.deleteBatchIds(orderNumberSet);
        if (CollectionUtils.isEmpty(orderNumberSet)) {
            return;
        }
        List kmsAcceptanceGoodsEntities = this.kmsAcceptanceGoodsMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumberSet));
        List kmsAcceptanceGoodsDetailDwEntities = this.kmsAcceptanceGoodsDetailDwMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(KmsAcceptanceGoodsDetailDwEntity::getOrderNumber, orderNumberSet));
        if (CollectionUtils.isNotEmpty((Collection)kmsAcceptanceGoodsEntities)) {
            this.kmsAcceptanceGoodsMapper.deleteBatchIds(kmsAcceptanceGoodsEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty((Collection)kmsAcceptanceGoodsDetailDwEntities)) {
            this.kmsAcceptanceGoodsDetailDwMapper.deleteBatchIds(kmsAcceptanceGoodsDetailDwEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toSet()));
        }
        KmsAuditFormReqVo kmsAuditFormReqVo = new KmsAuditFormReqVo();
        kmsAuditFormReqVo.setAcceptanceComNumberList((List)Lists.newArrayList(orderNumberSet));
        List<KmsAcceptanceMatchRelationRespVo> mapperMatchList = this.kmsAcceptanceMatchRelationMapper.findMatchList(kmsAuditFormReqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(mapperMatchList)) {
            List auditIds = mapperMatchList.stream().map(KmsAcceptanceMatchRelationRespVo::getAuditId).collect(Collectors.toList());
            KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
            formReqVo.setIds(auditIds);
            this.kmsAuditFormService.refreshAuditResult(formReqVo);
            Set relationIds = mapperMatchList.stream().map(UuidVo::getId).collect(Collectors.toSet());
            this.kmsAcceptanceMatchRelationMapper.deleteBatchIds(relationIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsAcceptanceFormReqVo reqVo) {
        List kmsAcceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsAcceptanceFormEntities)) {
            kmsAcceptanceFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsAcceptanceFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsAcceptanceFormReqVo reqVo) {
        List kmsAcceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsAcceptanceFormEntities)) {
            kmsAcceptanceFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsAcceptanceFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrans(KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        List ids = kmsAcceptanceFormReqVo.getIds();
        AssertUtils.isNotEmpty((Collection)ids, (String)"\u8bf7\u9009\u62e9\u5f85\u8f6c\u6362\u6570\u636e");
        List acceptanceFormEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        List detailDwRespVos = CrmBeanUtil.copyList((List)acceptanceFormEntities, KmsAcceptanceFormDetailDwRespVo.class);
        detailDwRespVos.forEach(dwRespVo -> {
            KmsAcceptanceFormEntity acceptanceFormEntity = this.kmsAcceptanceFormHelper.transFormVersion((KmsAcceptanceFormDetailDwRespVo)dwRespVo);
            if (!ObjectUtils.isEmpty((Object)acceptanceFormEntity)) {
                List<KmsAcceptanceGoodsEntity> goodsEntities = this.kmsAcceptanceFormHelper.transGoodsVersion(acceptanceFormEntity);
                this.kmsAcceptanceFormHelper.transData(acceptanceFormEntity, goodsEntities);
                this.saveOrUpdate(acceptanceFormEntity);
                this.kmsAcceptanceGoodsService.saveOrUpdateBatch(goodsEntities);
                this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntity);
                KmsAuditFormReqVo reqVo = new KmsAuditFormReqVo();
                reqVo.setAcceptanceComNumberList(acceptanceFormEntities.stream().map(KmsAcceptanceFormEntity::getOrderNumber).distinct().collect(Collectors.toList()));
                List<KmsAcceptanceMatchRelationRespVo> mapperMatchList = this.kmsAcceptanceMatchRelationMapper.findMatchList(reqVo);
                if (!org.springframework.util.CollectionUtils.isEmpty(mapperMatchList)) {
                    List auditIds = mapperMatchList.stream().map(KmsAcceptanceMatchRelationRespVo::getAuditId).collect(Collectors.toList());
                    KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
                    formReqVo.setIds(auditIds);
                    this.kmsAuditFormService.refreshAuditResult(formReqVo);
                }
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoTransData(KmsAcceptanceFormDetailDwRespVo dwRespVo) {
        KmsAcceptanceFormEntity acceptanceFormEntity = this.kmsAcceptanceFormHelper.transFormVersion(dwRespVo);
        if (!ObjectUtils.isEmpty((Object)acceptanceFormEntity)) {
            List<KmsAcceptanceGoodsEntity> goodsEntities = this.kmsAcceptanceFormHelper.transGoodsVersion(acceptanceFormEntity);
            this.kmsAcceptanceFormHelper.transData(acceptanceFormEntity, goodsEntities);
            this.saveOrUpdate(acceptanceFormEntity);
            this.kmsAcceptanceGoodsService.saveOrUpdateBatch(goodsEntities);
            this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditMatch(String orderNumber) {
        KmsAcceptanceFormEntity acceptanceFormEntity = (KmsAcceptanceFormEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(KmsAcceptanceFormEntity::getOrderNumber, (Object)orderNumber)).one();
        AssertUtils.isNotNull((Object)acceptanceFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        if (!KmsEnum.OrderStatus.S400.getValue().equals(acceptanceFormEntity.getOrderStatus())) {
            return;
        }
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsAcceptanceGoodsEntity::getOrderNumber, (Object)orderNumber);
        List goodsEntities = this.kmsAcceptanceGoodsMapper.selectList((Wrapper)build);
        List goodsCodes = goodsEntities.stream().filter(o -> !org.springframework.util.StringUtils.isEmpty((Object)o.getGoodsCode())).map(KmsAcceptanceGoodsEntity::getGoodsCode).collect(Collectors.toList());
        KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
        formReqVo.setBsDirectSystemId(acceptanceFormEntity.getBsDirectSystemId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)acceptanceFormEntity.getAuditDate())) {
            Date dateByFormat = DateUtil.getDateByFormat((String)acceptanceFormEntity.getAuditDate(), (String)"yyyy-MM-dd");
            String sapPostingDate = DateUtil.format((Date)dateByFormat, (String)"yyyyMMdd");
            formReqVo.setSapPostingDate(sapPostingDate);
            formReqVo.setSapMaterielCodeList(goodsCodes);
            List<KmsAuditFormRespVo> auditFormRespVos = this.kmsAuditFormMapper.findRespListByParams(formReqVo);
            auditFormRespVos.forEach(o -> {
                KmsAuditTemplateRespVo auditTemplateRespVo;
                List directVos;
                KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
                templateReqVo.setId(o.getAuditTemplateId());
                templateReqVo.setBsDirectSystemId(o.getBsDirectSystemId());
                List<KmsAuditTemplateRespVo> auditTemplateRespVos = this.kmsAuditTemplateService.findAll(templateReqVo);
                if (!org.springframework.util.CollectionUtils.isEmpty(auditTemplateRespVos) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(directVos = (auditTemplateRespVo = auditTemplateRespVos.get(0)).getDirectVos()))) {
                    this.kmsAuditFormService.auditMatch((KmsAuditFormRespVo)o, auditTemplateRespVo);
                    try {
                        o.setRemarks("\u5ef6\u8fdf\u6536\u8d27");
                        this.kmsAuditFormService.delayedReceipt((KmsAuditFormRespVo)o, auditTemplateRespVo);
                    }
                    catch (Exception e) {
                        log.info("\u5ef6\u8fdf\u6536\u8d27\u5904\u7406\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    }
                }
            });
        }
    }

    public void setData(List<KmsAcceptanceFormRespVo> list, Map<String, List<KmsAcceptanceGoodsEntity>> goodsMap, Map<String, String> orgCompanyMap, Map<String, List<KmsAcceptanceFormRespVo>> areaNameMap) {
        list.forEach(o -> {
            List vos;
            o.setFinalAcceptanceAmount(BigDecimal.ZERO.toString());
            List entities = (List)goodsMap.get(o.getOrderNumber());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)entities)) {
                entities.forEach(e -> {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)e.getAcceptanceAmount())) {
                        o.setFinalAcceptanceAmount(new BigDecimal(o.getFinalAcceptanceAmount()).add(new BigDecimal(e.getAcceptanceAmount())).toString());
                    }
                });
            }
            o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
            if (areaNameMap != null && CollectionUtil.listNotEmptyNotSizeZero((List)(vos = (List)areaNameMap.get(o.getStoreRelatedId())))) {
                o.setAreaName(((KmsAcceptanceFormRespVo)vos.get(0)).getAreaName());
            }
        });
    }
}

