/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.service.IKmsDirectSystemService;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsdirectsystem"})
@Api(tags={"KMS\u540e\u53f0\u5546\u8d85\u4fe1\u606f"})
public class KmsDirectSystemController {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectSystemController.class);
    @Autowired
    private IKmsDirectSystemService kmsDirectSystemService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsDirectSystemRespVo>> list(@RequestBody KmsDirectSystemReqVo kmsDirectSystemReqVo) {
        PageResult<KmsDirectSystemRespVo> result = this.kmsDirectSystemService.findList(kmsDirectSystemReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<KmsDirectSystemRespVo> query(@RequestParam(value="id", required=false) String id) {
        KmsDirectSystemRespVo respVo = this.kmsDirectSystemService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsDirectSystemReqVo kmsDirectSystemReqVo) {
        this.kmsDirectSystemService.save(kmsDirectSystemReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsDirectSystemReqVo kmsDirectSystemReqVo) {
        this.kmsDirectSystemService.update(kmsDirectSystemReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.kmsDirectSystemService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.kmsDirectSystemService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.kmsDirectSystemService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u76f4\u8425\u4f53\u7cfb\u67e5\u8be2\u5546\u8d85\u5217\u8868")
    @PostMapping(value={"/findDirectSystemList"})
    @CrmLog
    public Result<PageResult<KmsDirectSystemRespVo>> findDirectSystemList(@RequestBody KmsDirectSystemReqVo reqVo) {
        PageResult<KmsDirectSystemRespVo> respVos = this.kmsDirectSystemService.findDirectSystemList(reqVo);
        return Result.ok(respVos);
    }
}

