/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.confadmin.mapper.KmsInterfaceParamMapper;
import com.biz.crm.confadmin.mapper.KmsInterfaceParamOptionMapper;
import com.biz.crm.confadmin.mapper.KmsInterfaceSubParamOptionMapper;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamOptionReqVo;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceSubParamOptionReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamOptionRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceSubParamOptionRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectOrderTypeRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.TenantryDirectRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"KmsAdminServiceImpl"})
public class KmsAdminServiceImpl
implements IKmsAdminService {
    private static final Logger log = LoggerFactory.getLogger(KmsAdminServiceImpl.class);
    @Autowired
    private KmsConfig kmsConfig;
    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;
    @Resource
    private KmsInterfaceParamMapper kmsInterfaceParamMapper;
    @Resource
    private KmsInterfaceParamOptionMapper kmsInterfaceParamOptionMapper;
    @Resource
    private KmsInterfaceSubParamOptionMapper kmsInterfaceSubParamOptionMapper;

    @Override
    public PageResult<TenantryDirectRespVo> findTenantryDirectList(TenantryDirectReqVo params) {
        Page page = PageUtil.buildPage((Integer)params.getPageNum(), (Integer)params.getPageSize());
        List<TenantryDirectRespVo> list = this.kmsDirectSystemMapper.findDirectList((Page<KmsDirectStoreRespVo>)page, params);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<KmsDirectStoreRespVo> findTenantryDirectStoreList(TenantryDirectStoreReqVo params) {
        AssertUtils.isNotEmpty((String)params.getDirectId(), (String)"\u5546\u8d85ID[directId]\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)params.getPageNum(), (Integer)params.getPageSize());
        List<KmsDirectStoreRespVo> list = this.kmsDirectStoreMapper.findDirectStoreList((Page<KmsDirectStoreRespVo>)page, params);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<KmsDirectOrderTypeRespVo> findTenantryDirectOrderTypeList(TenantryDirectReqVo params) {
        AssertUtils.isNotEmpty((String)params.getDirectId(), (String)"\u5546\u8d85ID[directId]\u4e0d\u80fd\u4e3a\u7a7a");
        return this.kmsDirectOrderTypeMapper.findOrderTypeList(params);
    }

    @Override
    public List<KmsDirectOrderTypeRespVo> paramOrderTypeList(TenantryDirectReqVo params) {
        AssertUtils.isNotEmpty((String)params.getDirectId(), (String)"\u5546\u8d85ID[directId]\u4e0d\u80fd\u4e3a\u7a7a");
        List<KmsDirectOrderTypeRespVo> orderTypeList = this.kmsDirectOrderTypeMapper.findOrderTypeList(params);
        ArrayList orderTypeRespVos = Lists.newArrayList();
        KmsDirectOrderTypeRespVo respVo = new KmsDirectOrderTypeRespVo();
        respVo.setOrderType(KmsAdminEnum.OrderType.LOGIN_ORDER_TYPE.getValue());
        respVo.setOrderTypeName(KmsAdminEnum.OrderType.LOGIN_ORDER_TYPE.getDescription());
        orderTypeRespVos.add(respVo);
        orderTypeList.forEach(o -> {
            KmsDirectOrderTypeRespVo orderTypeRespVo = new KmsDirectOrderTypeRespVo();
            orderTypeRespVo.setOrderType(o.getOrderType());
            orderTypeRespVo.setOrderTypeName(o.getOrderTypeName());
            orderTypeRespVos.add(orderTypeRespVo);
        });
        return orderTypeRespVos;
    }

    @Override
    public List<BsGrabInterfaceParamRespVo> findGrabOrderParams(BsGrabInterfaceParamReqVo params) {
        AssertUtils.isNotEmpty((String)params.getDirectId(), (String)"\u5546\u8d85ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)params.getOrderType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList orderTypes = Lists.newArrayList();
        orderTypes.add(params.getOrderType());
        orderTypes.add(KmsAdminEnum.OrderType.LOGIN_ORDER_TYPE.getValue());
        params.setOrderTypes((List)orderTypes);
        params.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<BsGrabInterfaceParamRespVo> respVos = this.kmsInterfaceParamMapper.findGrabOrderParams(params);
        if (!CollectionUtils.isEmpty(respVos)) {
            List fields = respVos.stream().map(BsGrabInterfaceParamRespVo::getFieldId).collect(Collectors.toList());
            KmsInterfaceParamOptionReqVo optionReqVo = new KmsInterfaceParamOptionReqVo();
            optionReqVo.setFieldIds(fields);
            List<BsGrabInterfaceParamOptionRespVo> optionRespVos = this.kmsInterfaceParamOptionMapper.findOptionsByFieldIds(optionReqVo);
            Map<String, List<BsGrabInterfaceParamOptionRespVo>> optionMap = optionRespVos.stream().collect(Collectors.groupingBy(BsGrabInterfaceParamOptionRespVo::getFieldId));
            KmsInterfaceSubParamOptionReqVo subParamOptionReqVo = new KmsInterfaceSubParamOptionReqVo();
            subParamOptionReqVo.setFieldIds(fields);
            List<BsGrabInterfaceSubParamOptionRespVo> subParamOptionRespVos = this.kmsInterfaceSubParamOptionMapper.findSubParamOptionsByFieldIds(subParamOptionReqVo);
            Map<String, List<BsGrabInterfaceSubParamOptionRespVo>> subParamOptionMap = subParamOptionRespVos.stream().collect(Collectors.groupingBy(BsGrabInterfaceSubParamOptionRespVo::getFieldId));
            respVos.forEach(o -> {
                if (BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify()) || BaseClassifyConstants.FieldClassify.DATERANGE.getValue().equals(o.getFieldClassify())) {
                    List dateOptions = (List)optionMap.get(o.getFieldId());
                    dateOptions.forEach(dos -> {
                        Calendar cl = Calendar.getInstance();
                        cl.add(5, Integer.parseInt(dos.getOptionValue()) * -1);
                        dos.setOptionStartDate(DateUtil.getYYYYMMDD((Date)cl.getTime()));
                        if (!BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify())) {
                            dos.setOptionEndDate(DateUtil.getYYYYMMDD((Date)new Date()));
                        }
                    });
                    o.setOptions(dateOptions);
                } else {
                    o.setOptions((List)optionMap.get(o.getFieldId()));
                }
                o.setSubOptions((List)subParamOptionMap.get(o.getFieldId()));
            });
        }
        return respVos;
    }
}

