/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.confadmin.model.KmsDirectOrderTypeEntity;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KmsDirectSystemHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectSystemHelper.class);
    @Resource
    private KmsDirectSystemMapper directSystemMapper;
    @Resource
    private KmsDirectStoreMapper directStoreMapper;
    @Resource
    private KmsDirectOrderTypeMapper directOrderTypeMapper;

    public void paramCheck(KmsDirectSystemReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDirectName(), (String)"\u5546\u8d85\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVendorSystemUrl(), (String)"\u5546\u8d85\u7f51\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setVendorSystemUrl(reqVo.getVendorSystemUrl().trim());
        AssertUtils.isNotEmpty((Collection)reqVo.getOrderTypeVos(), (String)"\u652f\u6301\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet orderTypes = Sets.newHashSet();
        reqVo.getOrderTypeVos().forEach(x -> {
            AssertUtils.isNotEmpty((String)x.getOrderType(), (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)x.getOrderTypeName(), (String)"\u5355\u636e\u7c7b\u578b\u540d\u79f0[orderTypeName]\u4e0d\u80fd\u4e3a\u7a7a");
            if (orderTypes.contains(x.getOrderType())) {
                throw new BusinessException(x.getOrderType() + "\u7684\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u91cd\u590d\u9009\u62e9");
            }
            orderTypes.add(x.getOrderType());
        });
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        wrapper.eq(KmsDirectSystemEntity::getDirectName, (Object)reqVo.getDirectName());
        wrapper.eq(KmsDirectSystemEntity::getVendorSystemUrl, (Object)reqVo.getVendorSystemUrl());
        wrapper.eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty((Collection)this.directSystemMapper.selectList((Wrapper)wrapper))) {
            throw new BusinessException("\u8be5\u5546\u8d85\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728");
        }
    }

    public List<KmsDirectOrderTypeEntity> buildDirectOrderType(KmsDirectSystemReqVo reqVo) {
        ArrayList entities = Lists.newArrayList();
        reqVo.getOrderTypeVos().forEach(x -> {
            KmsDirectOrderTypeEntity entity = (KmsDirectOrderTypeEntity)CrmBeanUtil.copy((Object)x, KmsDirectOrderTypeEntity.class);
            entity.setDirectId(reqVo.getId());
            entities.add(entity);
        });
        return entities;
    }

    public void convertData(List<KmsDirectSystemRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Set idSet = list.stream().map(UuidVo::getId).collect(Collectors.toSet());
            List orderTypeEntityList = this.directOrderTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsDirectOrderTypeEntity::getDirectId, idSet)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
            Map<String, List<KmsDirectOrderTypeEntity>> orderTypeMap = orderTypeEntityList.stream().collect(Collectors.groupingBy(KmsDirectOrderTypeEntity::getDirectId));
            list.forEach(x -> {
                List orderTypeEntities = (List)orderTypeMap.get(x.getId());
                List orderTypeNames = orderTypeEntities.stream().map(KmsDirectOrderTypeEntity::getOrderTypeName).collect(Collectors.toList());
                x.setOrderTypeStr(orderTypeNames.stream().collect(Collectors.joining(",")));
            });
        }
    }

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }
}

