/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.confadmin.mapper.KmsDirectThreadMapper;
import com.biz.crm.confadmin.model.KmsDirectOrderTypeEntity;
import com.biz.crm.confadmin.model.KmsDirectThreadEntity;
import com.biz.crm.confadmin.service.IKmsDirectThreadService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectThreadReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectThreadRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsDirectThreadServiceExpandImpl"})
public class KmsDirectThreadServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsDirectThreadMapper, KmsDirectThreadEntity>
implements IKmsDirectThreadService {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectThreadServiceImpl.class);
    @Resource
    private KmsDirectThreadMapper kmsDirectThreadMapper;
    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("kms_file_classify");
        dictCodes.add("kms_order_type");
        dictCodes.add("kms_order_download_way");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    @Override
    public PageResult<KmsDirectThreadRespVo> findList(KmsDirectThreadReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsDirectThreadRespVo> list = this.kmsDirectThreadMapper.findList((Page<KmsDirectThreadRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> kmsDataMap = this.getDictMaps();
            list.forEach(x -> {
                if (ObjectUtils.isEmpty((Object)x.getFileClassify())) {
                    x.setFileClassifyDesc((String)((Map)Optional.ofNullable(kmsDataMap.get("kms_file_classify")).orElse(Maps.newHashMap())).get(x.getFileClassify().toString()));
                }
                if (StringUtils.isNotBlank((CharSequence)x.getOrderType())) {
                    x.setOrderTypeName((String)((Map)Optional.ofNullable(kmsDataMap.get("kms_order_type")).orElse(Maps.newHashMap())).get(x.getOrderType()));
                }
                if (ObjectUtils.isEmpty((Object)x.getFileDownloadWay())) {
                    x.setFileDownloadWayDesc((String)((Map)Optional.ofNullable(kmsDataMap.get("kms_order_download_way")).orElse(Maps.newHashMap())).get(x.getFileDownloadWay().toString()));
                }
                if (ObjectUtils.isEmpty((Object)x.getOrderDownloadWay())) {
                    x.setOrderDownloadWayDesc((String)((Map)Optional.ofNullable(kmsDataMap.get("kms_order_download_way")).orElse(Maps.newHashMap())).get(x.getOrderDownloadWay().toString()));
                }
                if (StringUtils.isNotBlank((CharSequence)x.getEnableStatus())) {
                    x.setEnableStatusName((String)((Map)Optional.ofNullable(kmsDataMap.get("enable_status")).orElse(Maps.newHashMap())).get(x.getEnableStatus()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsDirectThreadRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsDirectThreadReqVo reqVo = new KmsDirectThreadReqVo();
        reqVo.setId(id);
        List respVos = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (KmsDirectThreadRespVo)respVos.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsDirectThreadReqVo reqVo) {
        this.saveOrUpdateCheck(reqVo);
        KmsDirectThreadEntity entity = (KmsDirectThreadEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectThreadEntity.class);
        this.save(entity);
        KmsDirectThreadRespVo newData = (KmsDirectThreadRespVo)CrmBeanUtil.copy((Object)entity, KmsDirectThreadRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    protected void saveOrUpdateCheck(KmsDirectThreadReqVo reqVo) {
        this.checkDataNotEmpty(reqVo);
        List orderTypeEntities = this.kmsDirectOrderTypeMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(KmsDirectOrderTypeEntity::getDirectId, (Object)reqVo.getDirectId()));
        if (CollectionUtils.isEmpty((Collection)orderTypeEntities)) {
            throw new BusinessException("\u6240\u9009\u5546\u8d85\u7cfb\u7edf\u6ca1\u6709\u652f\u6301\u7684\u5355\u636e\u7c7b\u578b");
        }
        Set orderTypeSet = orderTypeEntities.stream().map(KmsDirectOrderTypeEntity::getOrderType).collect(Collectors.toSet());
        if (!orderTypeSet.contains(reqVo.getOrderType())) {
            throw new BusinessException("\u8be5\u5546\u8d85\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u5355\u636e\u7c7b\u578b");
        }
        this.checkThreadDataExist(reqVo);
    }

    private void checkThreadDataExist(KmsDirectThreadReqVo reqVo) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        wrapper.eq(KmsDirectThreadEntity::getDirectId, (Object)reqVo.getDirectId());
        wrapper.eq(KmsDirectThreadEntity::getOrderType, (Object)reqVo.getOrderType());
        wrapper.eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        List entities = this.kmsDirectThreadMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u8be5\u5546\u8d85\u7cfb\u7edf\u7684\u8be5\u5355\u636e\u6293\u53d6\u65b9\u5f0f\u5df2\u5b58\u5728");
        }
    }

    private void checkDataNotEmpty(KmsDirectThreadReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDirectId(), (String)"\u5546\u8d85\u7cfb\u7edf\u4e0d\u80fd\u4e0d\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrderType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getOrderDownloadWay(), (String)"\u5355\u636e\u4e0b\u8f7d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsDirectThreadReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        AssertUtils.isNotNull((Object)this.kmsDirectThreadMapper.selectById((Serializable)((Object)reqVo.getId())), (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
        this.saveOrUpdateCheck(reqVo);
        KmsDirectThreadEntity entity = (KmsDirectThreadEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectThreadEntity.class);
        KmsDirectThreadRespVo oldData = this.query(reqVo.getId());
        this.updateById(entity);
        KmsDirectThreadRespVo newData = this.query(reqVo.getId());
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectThreadEntities = this.kmsDirectThreadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectThreadEntities)) {
            kmsDirectThreadEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsDirectThreadEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectThreadEntities = this.kmsDirectThreadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectThreadEntities)) {
            kmsDirectThreadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsDirectThreadEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectThreadEntities = this.kmsDirectThreadMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectThreadEntities)) {
            kmsDirectThreadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsDirectThreadEntities);
    }
}

