/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditTemplateDirectService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormExportRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsauditform"})
@Api(tags={"\u7a3d\u6838\u6570\u636e"})
public class KmsAuditFormController {
    private static final Logger log = LoggerFactory.getLogger(KmsAuditFormController.class);
    @Autowired
    private IKmsAuditFormService kmsAuditFormService;
    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;
    @Resource
    private IKmsAuditTemplateDirectService kmsAuditTemplateDirectService;
    @Resource
    private RedissonUtil redissonUtil;
    @Resource
    private KmsConfig kmsConfig;

    @ApiOperation(value="\u7a3d\u6838\u5339\u914d\u5217\u8868")
    @PostMapping(value={"/matchList"})
    @CrmLog
    public Result<PageResult<KmsAuditFormRespVo>> matchList(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        kmsAuditFormReqVo.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        PageResult<KmsAuditFormRespVo> result = this.kmsAuditFormService.findList(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u672a\u5339\u914d\u9a8c\u6536\u5355\u67e5\u8be2\u7a3d\u6838\u5339\u914d\u5217\u8868")
    @PostMapping(value={"/selectMatchList"})
    @CrmLog
    public Result<PageResult<KmsAuditFormRespVo>> selectMatchList(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        kmsAuditFormReqVo.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        PageResult<KmsAuditFormRespVo> result = this.kmsAuditFormService.selectMatchList(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u7a3d\u6838\u6838\u5b9a\u5217\u8868")
    @PostMapping(value={"/approvedList"})
    @CrmLog
    public Result<PageResult<KmsAuditFormRespVo>> approvedList(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        kmsAuditFormReqVo.setAuditStatus(KmsEnum.AuditStatus.CONFIRMED.getValue());
        PageResult<KmsAuditFormRespVo> result = this.kmsAuditFormService.findList(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u7a3d\u6838\u5339\u914d\u6c47\u603b\u62a5\u8868")
    @PostMapping(value={"/matchSummaryReport"})
    @CrmLog
    public Result<PageResult<KmsAuditFormRespVo>> matchSummaryReport(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "audit_summary_list");
        kmsAuditFormReqVo.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        PageResult<KmsAuditFormRespVo> result = this.kmsAuditFormService.matchSummaryReport(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u7a3d\u6838\u5339\u914d\u6c47\u603b")
    @PostMapping(value={"/matchSummaryTotalCount"})
    @CrmLog
    public Result<KmsAuditFormRespVo> matchSummaryTotalCount(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        kmsAuditFormReqVo.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "audit_summary_list");
        KmsAuditFormRespVo result = this.kmsAuditFormService.matchSummaryTotalCount(kmsAuditFormReqVo);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u7a3d\u6838\u5339\u914d\u5bfc\u51fa")
    @PostMapping(value={"/auditExport"})
    @CrmLog
    public Result<PageResult<KmsAuditFormExportRespVo>> auditExport(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        kmsAuditFormReqVo.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        PageResult<KmsAuditFormExportRespVo> result = this.kmsAuditFormService.auditExport(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u672a\u5339\u914d\u9a8c\u6536\u5355\u5217\u8868")
    @PostMapping(value={"/notmatchedAcceptanceFormList"})
    @CrmLog
    public Result<PageResult<KmsAuditAcceptanceFormRespVo>> notmatchedAcceptanceFormList(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        PageResult<KmsAuditAcceptanceFormRespVo> result = this.kmsAuditFormService.notmatchedAcceptanceFormList(kmsAcceptanceFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2/\u624b\u52a8\u53d6\u6d88\u5339\u914d\u8be6\u60c5")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsAuditFormRespVo> query(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        KmsAuditFormRespVo respVo = this.kmsAuditFormService.query(kmsAuditFormReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u624b\u52a8\u5339\u914d\u67e5\u8be2\u5df2\u5339\u914d\u9a8c\u6536\u5355\u6570\u636e\u5217\u8868")
    @PostMapping(value={"/matchedAcc"})
    @CrmLog
    public Result<PageResult<KmsAuditAcceptanceFormRespVo>> matchedAcc(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        PageResult<KmsAuditAcceptanceFormRespVo> result = this.kmsAuditFormService.matchedAcc(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="\u62c9\u53d6SAP\u6570\u636e\uff08\u7528\u4e8e\u6c47\u603b\u7a3d\u6838\u57fa\u7840\u6570\u636e\uff09")
    @PostMapping(value={"/pullSap"})
    @CrmLog
    public Result pullSap(@RequestBody KmsSapOrderFormReqVo kmsSapOrderFormReqVo) {
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        templateReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        templateReqVo.setBsDirectSystemId(kmsSapOrderFormReqVo.getBsDirectSystemId());
        templateReqVo.setId(kmsSapOrderFormReqVo.getAuditTemplateId());
        List<KmsAuditTemplateRespVo> auditTemplateRespVos = this.kmsAuditTemplateService.findAll(templateReqVo);
        AssertUtils.isNotEmpty(auditTemplateRespVos, (String)"\u672a\u67e5\u8be2\u5230\u6a21\u7248\u4fe1\u606f");
        auditTemplateRespVos.forEach(o -> {
            MdmOrgRespVo companyOrg = KmsOrgUtil.getCompanyOrg(o.getCreateOrgCode());
            AssertUtils.isNotNull((Object)companyOrg, (String)("\u6a21\u7248[" + o.getTemplateName() + "]\u6ca1\u6709\u6240\u5c5e\u516c\u53f8\u4fe1\u606f!"));
            o.setSapOrgCode(companyOrg.getSapOrgCode());
            o.setOrgCode(companyOrg.getOrgCode());
        });
        List sapOrgCodes = auditTemplateRespVos.stream().map(KmsAuditTemplateRespVo::getOrgCode).distinct().collect(Collectors.toList());
        if (sapOrgCodes.size() > 1) {
            throw new BusinessException("\u5339\u914d\u6a21\u7248\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u4e0d\u540c");
        }
        RLock rLock = null;
        try {
            rLock = this.redissonUtil.createLock("PULL_SAP_LOCK_KEY_" + (String)sapOrgCodes.get(0));
            if (!this.redissonUtil.tryLock(rLock, 0L, 1800L)) throw new BusinessException("\u6709\u4eba\u6b63\u5728\u6293\u53d6SAP\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            kmsSapOrderFormReqVo.setAuditTemplateVo(auditTemplateRespVos);
            this.kmsAuditFormService.pullSap(kmsSapOrderFormReqVo);
            if (!CollectionUtils.isEmpty((Collection)kmsSapOrderFormReqVo.getInvoiceIds())) {
                this.kmsAuditFormService.pullSapSummary(kmsSapOrderFormReqVo);
            }
        }
        catch (BusinessException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.redissonUtil.unLock(rLock);
                throw throwable;
            }
        }
        this.redissonUtil.unLock(rLock);
        return Result.ok();
    }

    @ApiOperation(value="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @CrmLog
    public Result confirm(@RequestBody List<String> ids) {
        this.kmsAuditFormService.confirm(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u53d6\u6d88\u786e\u8ba4")
    @PostMapping(value={"/cancelConfirm"})
    @CrmLog
    public Result cancelConfirm(@RequestBody List<String> ids) {
        this.kmsAuditFormService.cancelConfirm(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664\u7a3d\u6838\u6570\u636e")
    @PostMapping(value={"/deleteBatch"})
    @CrmLog
    public Result deleteBatch(@RequestBody List<String> ids) {
        ids.forEach(i -> {
            KmsAuditFormReqVo kmsAuditFormReqVo = new KmsAuditFormReqVo();
            kmsAuditFormReqVo.setId(i);
            this.kmsAuditFormService.deleteBatch(kmsAuditFormReqVo);
        });
        return Result.ok();
    }

    @ApiOperation(value="\u6dfb\u52a0\u5907\u6ce8")
    @PostMapping(value={"/addRemark"})
    @CrmLog
    public Result addRemark(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        this.kmsAuditFormService.addRemark(kmsAuditFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u624b\u52a8\u53d6\u6d88\u5339\u914d\u63d0\u4ea4")
    @PostMapping(value={"/manualCancelmatch"})
    @CrmLog
    public Result manualCancelmatch(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        this.kmsAuditFormService.manualCancelmatch(kmsAuditFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u624b\u52a8\u5339\u914d\u8be6\u60c5")
    @PostMapping(value={"/manualmatchQuery"})
    @CrmLog
    public Result<KmsAuditFormRespVo> manualmatchQuery(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        KmsAuditFormRespVo respVo = this.kmsAuditFormService.manualmatchQuery(kmsAuditFormReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u624b\u52a8\u5339\u914d\u67e5\u8be2\u5f85\u5339\u914d\u9a8c\u6536\u5355\u6570\u636e\u5217\u8868")
    @PostMapping(value={"/waitMatchedAcc"})
    @CrmLog
    public Result<PageResult<KmsAuditAcceptanceFormRespVo>> waitMatchedAcc(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        PageResult<KmsAuditAcceptanceFormRespVo> result = this.kmsAuditFormService.waitMatchedAcc(kmsAuditFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u624b\u52a8\u5339\u914d\u63d0\u4ea4")
    @PostMapping(value={"/manualmatch"})
    @CrmLog
    public Result manualmatch(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        this.kmsAuditFormService.manualmatch(kmsAuditFormReqVo);
        return Result.ok();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="\u624b\u52a8\u6279\u91cf\u5339\u914d")
    @PostMapping(value={"/manualBstchMatch"})
    @CrmLog
    public Result manualBstchMatch(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        List<KmsAuditFormRespVo> auditFormRespVos = this.kmsAuditFormService.findListByIds(ids);
        KmsAuditFormRespVo auditFormRespVo = auditFormRespVos.get(0);
        String orgCode = auditFormRespVo.getOrgCode();
        String auditTemplateId = auditFormRespVo.getAuditTemplateId();
        RLock rLock = null;
        try {
            rLock = this.redissonUtil.createLock("MANUAL_BSTCH_MATCH_LOCK_KEY_" + orgCode);
            if (!this.redissonUtil.tryLock(rLock, 0L, 1800L)) throw new BusinessException("\u6709\u4eba\u6b63\u5728\u5904\u7406\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setId(auditTemplateId);
            List<KmsAuditTemplateRespVo> auditTemplateRespVos = this.kmsAuditTemplateService.findAll(templateReqVo);
            KmsAuditTemplateRespVo auditTemplateRespVo = auditTemplateRespVos.get(0);
            auditFormRespVos.stream().forEach(o -> {
                this.kmsAuditFormService.auditMatch((KmsAuditFormRespVo)o, auditTemplateRespVo);
                o.setRemarks("\u5ef6\u8fdf\u6536\u8d27");
                this.kmsAuditFormService.delayedReceipt((KmsAuditFormRespVo)o, auditTemplateRespVo);
            });
        }
        catch (BusinessException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.redissonUtil.unLock(rLock);
                throw throwable;
            }
        }
        this.redissonUtil.unLock(rLock);
        return Result.ok();
    }

    @ApiOperation(value="\u672a\u5339\u914d\u9a8c\u6536\u5355\u5339\u914d\u7a3d\u6838\u5355\u63d0\u4ea4")
    @PostMapping(value={"/submitUnmatchedAcce"})
    @CrmLog
    public Result submitUnmatchedAcce(@RequestBody KmsAuditFormReqVo kmsAuditFormReqVo) {
        this.kmsAuditFormService.submitUnmatchedAcce(kmsAuditFormReqVo);
        return Result.ok();
    }
}

