/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.funcation;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.annotation.KmsFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@KmsFunction(code=KmsAuditConditionEnum.PDSO, name="\u95e8\u5e97+\u5546\u54c1+\u8ba2\u5355\u53f7", desc="\u7a3d\u6838\u6761\u4ef6")
public class KmsPdsoFunction
implements BaseAuditFunction {
    private static final Logger log = LoggerFactory.getLogger(KmsPdsoFunction.class);
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;
    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;
    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a, KmsAuditTemplateDirectRespVo templateDirectRespVo, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {
        KmsSapInvoiceRespVo e = invoice.get(0);
        HashMap summaryInvStoreMap = Maps.newHashMap();
        HashMap summaryAuditStoreMap = Maps.newHashMap();
        ArrayList bstkdList = Lists.newArrayList();
        invoice.forEach(invo -> {
            invo.setKunnr(KmsUtils.removeFrontZero(invo.getKunnr()));
            invo.setKunag(KmsUtils.removeFrontZero(invo.getKunag()));
            invo.setMatnr(KmsUtils.removeFrontZero(invo.getMatnr()));
            invo.setIsStore(YesNoEnum.yesNoEnum.Y.getValue());
            if (StringUtils.isEmpty((Object)invo.getBstkd())) {
                invo.setBstkd("DC" + invo.getFkdat());
            }
            bstkdList.add(invo.getBstkd());
            String storeKey = invo.getKunnr() + "-" + invo.getMatnr() + "-" + invo.getBstkd();
            List invoS = (List)summaryInvStoreMap.get(storeKey);
            if (CollectionUtils.isEmpty((Collection)invoS)) {
                invoS = Lists.newArrayList();
            }
            invoS.add(invo);
            summaryInvStoreMap.put(storeKey, invoS);
        });
        String templateId = a.getId();
        KmsAuditFormReqVo params = new KmsAuditFormReqVo();
        params.setBukrs(e.getBukrs());
        params.setOrgCode(e.getOrgCode());
        params.setAuditTemplateId(templateId);
        params.setBsDirectSystemId(a.getBsDirectSystemId());
        params.setBstkdList(bstkdList.stream().distinct().collect(Collectors.toList()));
        List<KmsAuditFormEntity> afeEntities = this.kmsAuditFormMapper.findListByParams(params);
        afeEntities.forEach(audit -> {
            String storeKey = audit.getStoreCode() + "-" + audit.getSapMaterielCode() + "-" + audit.getKaOrderNumber();
            summaryAuditStoreMap.put(storeKey, audit);
        });
        summaryInvStoreMap.forEach((k, v) -> {
            KmsAuditFormEntity afe = (KmsAuditFormEntity)summaryAuditStoreMap.get(k);
            if (ObjectUtils.isEmpty((Object)afe)) {
                afe = new KmsAuditFormEntity();
                KmsSapInvoiceRespVo i = (KmsSapInvoiceRespVo)v.get(0);
                this.buildAuditForm(afe, i, templateDirectRespVo);
                afe.setProductType(i.getMtpos());
                afe.setDirectName(a.getBsDirectSystemName());
                afe.setBsDirectSystemId(a.getBsDirectSystemId());
                auditFormEntities.add(afe);
                for (int iv = 0; iv < v.size(); ++iv) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(((KmsSapInvoiceRespVo)v.get(iv)).getId());
                    relationEntities.add(relationEntity);
                }
            } else {
                for (int iv = 0; iv < v.size(); ++iv) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditId(afe.getId());
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(((KmsSapInvoiceRespVo)v.get(iv)).getId());
                    relationEntities.add(relationEntity);
                }
            }
        });
    }

    private void buildAuditForm(KmsAuditFormEntity afe, KmsSapInvoiceRespVo e, KmsAuditTemplateDirectRespVo templateDirectRespVo) {
        afe.setKaOrderNumber(e.getBstkd());
        afe.setDirectName(templateDirectRespVo.getDirectName());
        afe.setBsDirectSystemId(templateDirectRespVo.getBsDirectSystemId());
        afe.setBsDirectSystemCode(templateDirectRespVo.getBsDirectSystemCode());
        afe.setBsDirectSystemName(templateDirectRespVo.getBsDirectSystemName());
        afe.setAuditNumber(CodeUtil.generateCode((String)"kms_audit_code"));
        afe.setStoreCode(KmsUtils.removeFrontZero(e.getKunnr()));
        afe.setStoreName(e.getKunnrname());
        afe.setBukrs(e.getBukrs());
        afe.setOrgCode(e.getOrgCode());
        afe.setCreateOrgCode(e.getOrgCode());
        afe.setSapPostingDate(e.getFkdat());
        afe.setSapMaterielCode(KmsUtils.removeFrontZero(e.getMatnr()));
        afe.setSapMaterielName(e.getMaktx());
        afe.setSapQuantity("0");
        afe.setIsStoreSummary(YesNoEnum.yesNoEnum.Y.getValue());
        afe.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        afe.setAcceptanceQuantity("0");
        afe.setSapAmountNot("0");
        afe.setSapAmount("0");
        afe.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        afe.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
        afe.setAcceptanceAmount("0");
        afe.setAcceptanceAmountNot("0");
        afe.setAuditTemplateId(templateDirectRespVo.getAuditTemplateId());
        afe.setDifferencePrice(templateDirectRespVo.getDifferencePrice());
        afe.setAuditRule(templateDirectRespVo.getAuditRule());
    }

    private void saveMatchRelation(KmsAuditFormEntity afe, String relationId, String templateId) {
        KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
        relationEntity.setAuditId(afe.getId());
        relationEntity.setAuditNumber(afe.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setRelationId(relationId);
        this.kmsAuditMatchRelationMapper.insert(relationEntity);
    }

    @Override
    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        List relationEntities = ((LambdaQueryChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaQuery().eq(KmsAcceptanceMatchRelationEntity::getAuditId, (Object)respVo.getId())).list();
        if (!CollectionUtils.isEmpty((Collection)relationEntities)) {
            List<String> relationIds = relationEntities.stream().map(KmsAcceptanceMatchRelationEntity::getRelationId).collect(Collectors.toList());
            this.findMatchDataByIds(relationIds, respVo, templateRespVo);
            this.cancelMatchData(relationIds, respVo, templateRespVo);
        }
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setStoreCode(respVo.getStoreCode());
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setProductCode(respVo.getSapMaterielCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setBsDirectSystemId(respVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> productRespVos = this.kmsTenantryDirectProductMapper.findListByWeek(params);
        if (CollectionUtils.isEmpty(productRespVos)) {
            reqVo.setGoodsCode(respVo.getSapMaterielCode());
        } else {
            reqVo.setKaGoodsCodeList(productRespVos.stream().map(KmsTenantryDirectProductRespVo::getKaProductCode).distinct().collect(Collectors.toList()));
        }
        reqVo.setAuditTemplateId(respVo.getAuditTemplateId());
        reqVo.setBsDirectSystemId(respVo.getBsDirectSystemId());
        String[] split = respVo.getKaOrderNumber().split("-");
        reqVo.setRelateKaOrderNumber("NULLORDER");
        if (split.length == 3) {
            reqVo.setRelateKaOrderNumber(split[1]);
        }
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = this.kmsAcceptanceFormMapper.findMatchedPDS(reqVo);
        acceptanceFormRespVos.forEach(a -> a.setId(a.getGoodsId()));
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    @Override
    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = this.kmsAcceptanceFormMapper.findMatchedSuccPDS(reqVo);
        acceptanceFormSuccRespVos.forEach(a -> a.setId(a.getGoodsId()));
        respVo.setAcceptanceFormVos(acceptanceFormSuccRespVos);
    }

    @Override
    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        ArrayList relationEntities = Lists.newArrayList();
        ArrayList accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> {
            KmsAcceptanceMatchRelationEntity relationEntity = KmsUtils.buildAcceptanceMatchRelation(o, afVo, templateRespVo.getId());
            relationEntities.add(relationEntity);
            accIds.add(o.getHeaderId());
        });
        if (!CollectionUtils.isEmpty((Collection)relationEntities)) {
            afVo.setIsAudit(YesNoEnum.yesNoEnum.yes.getValue());
            this.kmsAcceptanceMatchRelationService.saveBatch(relationEntities);
            List acceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                if (!KmsEnum.OrderStatus.S100.getValue().equals(a.getOrderStatus())) {
                    a.setOrderStatus(KmsEnum.OrderStatus.S600.getValue());
                    a.setOrderStatusMsg(KmsEnum.OrderStatus.S600.getDescription());
                }
                this.kmsAcceptanceFormMapper.updateById(a);
            });
            this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
        }
    }

    @Override
    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setIds(relationIdIds);
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = this.kmsAcceptanceFormMapper.findMatchedPDS(reqVo);
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    @Override
    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        ArrayList accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> accIds.add(o.getHeaderId()));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaUpdate().eq(KmsAcceptanceMatchRelationEntity::getAuditId, (Object)afVo.getId())).eq(KmsAcceptanceMatchRelationEntity::getAuditTemplateId, (Object)templateRespVo.getId())).in(KmsAcceptanceMatchRelationEntity::getRelationId, relationIdIds)).remove();
        ArrayList entities = CollectionUtils.isEmpty((Collection)accIds) ? Lists.newArrayList() : ((LambdaQueryChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaQuery().in(KmsAcceptanceMatchRelationEntity::getHeaderId, (Collection)accIds)).list();
        Map<String, List<KmsAcceptanceMatchRelationEntity>> listMap = entities.stream().collect(Collectors.groupingBy(KmsAcceptanceMatchRelationEntity::getHeaderId));
        ArrayList notRelationIds = Lists.newArrayList();
        accIds.forEach(o -> {
            List relationEntities = (List)listMap.get(o);
            if (CollectionUtils.isEmpty((Collection)relationEntities)) {
                notRelationIds.add(o);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)notRelationIds)) {
            List acceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                if (KmsEnum.OrderStatus.S400.getDescription().equals(a.getOrderStatusMsg()) || KmsEnum.OrderStatus.S600.getDescription().equals(a.getOrderStatusMsg())) {
                    a.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                    a.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
                } else {
                    a.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                }
                this.kmsAcceptanceFormMapper.updateById(a);
            });
            this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
            afVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        }
    }

    @Override
    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        return this.kmsAcceptanceFormMapper.findNotMatchedPDS(page, reqVo);
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        String[] split;
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setStoreCode(respVo.getStoreCode());
        queryVo.setBsDirectSystemId(respVo.getBsDirectSystemId());
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setProductCode(respVo.getSapMaterielCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setBsDirectSystemId(respVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> productRespVos = this.kmsTenantryDirectProductMapper.findListByWeek(params);
        if (CollectionUtils.isEmpty(productRespVos)) {
            queryVo.setGoodsCode(respVo.getSapMaterielCode());
        } else {
            queryVo.setKaGoodsCodeList(productRespVos.stream().map(KmsTenantryDirectProductRespVo::getKaProductCode).distinct().collect(Collectors.toList()));
        }
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        String kaOrderNumber = respVo.getKaOrderNumber();
        queryVo.setRelateKaOrderNumber("NULLORDER");
        if (!StringUtils.isEmpty((Object)kaOrderNumber) && (split = kaOrderNumber.split("-")).length == 3) {
            queryVo.setRelateKaOrderNumber(split[1]);
        }
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedPDS((Page<KmsAuditAcceptanceFormRespVo>)page, queryVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedSuccPDS((Page<KmsAuditAcceptanceFormRespVo>)page, queryVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {
    }
}

