/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.helper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.funcation.KmsAuditFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormExportRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class KmsAuditFormHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsAuditFormHelper.class);
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;
    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;
    private static final BigDecimal BASE_1000 = new BigDecimal(1000);
    @Resource
    private KmsAuditFunction kmsAuditFunction;
    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;

    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {
        String templateId = a.getId();
        Map directRespVoMap = a.getDirectVos().stream().collect(Collectors.toMap(KmsAuditTemplateDirectRespVo::getBsDirectSystemId, Function.identity()));
        KmsAuditTemplateDirectRespVo templateDirectRespVo = (KmsAuditTemplateDirectRespVo)directRespVoMap.get(a.getBsDirectSystemId());
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(a));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.summary(invoice, a, templateDirectRespVo, auditFormEntities, relationEntities);
    }

    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.matchData(respVo, templateRespVo);
    }

    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.matchDataSucc(respVo, templateRespVo);
    }

    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.matchDataBinding(afVo, templateRespVo);
    }

    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.findMatchDataByIds(relationIdIds, respVo, templateRespVo);
    }

    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.cancelMatchData(relationIdIds, afVo, templateRespVo);
    }

    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(reqVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        List directIds = templateRespVo.getDirectVos().stream().map(KmsAuditTemplateDirectRespVo::getDirectId).collect(Collectors.toList());
        reqVo.setDirectIds(directIds);
        KmsAuditConditionEnum conditionEnum = KmsUtils.getConditionEnum(templateRespVo);
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return Lists.newArrayList();
        }
        return baseAuditFunction.notmatchedAcceptanceFormList(page, reqVo);
    }

    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return new PageResult();
        }
        return baseAuditFunction.waitMatchedAcc(reqVo, respVo, templateRespVo);
    }

    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(templateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return new PageResult();
        }
        return baseAuditFunction.matchedAcc(reqVo, respVo, templateRespVo);
    }

    public List<KmsAuditFormExportRespVo> buildAuditExport(List<KmsAuditFormRespVo> list) {
        ArrayList exportRespVos = Lists.newArrayList();
        list.forEach(o -> {
            o.setAuditResult((String)KmsEnum.AuditResult.GETMAP.get(o.getAuditResult()));
            o.setAuditStatus((String)KmsEnum.AuditStatus.GETMAP.get(o.getAuditStatus()));
            ArrayList respVos = Lists.newArrayList();
            List sapOrderFormVos = o.getSapOrderFormVos();
            List acceptanceFormVos = o.getAcceptanceFormVos();
            int aSize = sapOrderFormVos.size();
            int bSize = acceptanceFormVos.size();
            int size = aSize >= bSize ? aSize : bSize;
            for (int i = 0; i < size; ++i) {
                KmsAuditFormExportRespVo vo = new KmsAuditFormExportRespVo();
                if (respVos.size() == 0) {
                    vo = (KmsAuditFormExportRespVo)CrmBeanUtil.copy((Object)o, KmsAuditFormExportRespVo.class);
                    vo.setSapPostingDateExport(DateUtil.format((Date)DateUtil.getDateByFormat((String)vo.getSapPostingDate(), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
                }
                if (sapOrderFormVos.size() - 1 >= i) {
                    KmsSapOrderFormRespVo sapVo = (KmsSapOrderFormRespVo)sapOrderFormVos.get(i);
                    vo.setName4(sapVo.getName4());
                    vo.setPernr(sapVo.getPernr());
                    vo.setDistributor(sapVo.getDistributor());
                    vo.setSapNo(sapVo.getSapNo());
                    vo.setVgbel(sapVo.getVgbel());
                    vo.setItemSapAmount(sapVo.getSapAmount().toString());
                    vo.setItemSapAmountNot(sapVo.getSapAmountNot().toString());
                    vo.setItemSapDistributor(sapVo.getDistributor());
                    vo.setItemSapKunag(sapVo.getKunag());
                    vo.setItemSapKunagname(sapVo.getKunagname());
                    vo.setItemSapKunnr(sapVo.getKunnr());
                    vo.setItemSapKunnrname(sapVo.getKunnrname());
                    vo.setItemSapMaterielCode(sapVo.getSapMaterielCode());
                    vo.setItemSapMaterielName(sapVo.getSapMaterielName());
                    vo.setItemSapPostingDate(DateUtil.format((Date)DateUtil.getDateByFormat((String)sapVo.getSapPostingDate(), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
                    vo.setItemSapProductType(sapVo.getProductType());
                    vo.setItemSapQuantity(sapVo.getSapQuantity().toString());
                    vo.setItemSapStoreCode(sapVo.getStoreCode());
                    vo.setItemSapStoreName(sapVo.getStoreName());
                    vo.setNetwr(sapVo.getNetwr().toString());
                    vo.setMwsbp(sapVo.getMwsi1().toString());
                    vo.setKzwi1(sapVo.getKzwi1().toString());
                    vo.setKzwi4(sapVo.getKzwi4().toString());
                    vo.setMwsi1(sapVo.getMwsi1().toString());
                    vo.setYk04(sapVo.getYk04().toString());
                    vo.setYk11(sapVo.getYk11().toString());
                    vo.setYk99(sapVo.getYk99().toString());
                    vo.setZst2(sapVo.getZst2().toString());
                    vo.setErzet(DateUtil.format((Date)DateUtil.getDateByFormat((String)sapVo.getErzet(), (String)"yyyyMMddHHmmss"), (String)"yyyy-MM-dd"));
                    vo.setAubel(sapVo.getAubel());
                    vo.setVbakerdat(DateUtil.format((Date)DateUtil.getDateByFormat((String)sapVo.getVbakerdat(), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
                }
                if (acceptanceFormVos.size() - 1 >= i) {
                    KmsAuditAcceptanceFormRespVo accVo = (KmsAuditAcceptanceFormRespVo)acceptanceFormVos.get(i);
                    vo.setItemAccAcceptanceAmount(accVo.getAcceptanceAmount());
                    vo.setItemAccAcceptanceAmountNot(accVo.getAcceptanceAmountNot());
                    vo.setItemAccAcceptanceDate(accVo.getAcceptanceDate());
                    vo.setItemAccAcceptanceQuantity(accVo.getAcceptanceQuantity());
                    vo.setItemAccAcceptanceType(accVo.getAcceptanceType());
                    vo.setItemAccAreaCode(accVo.getAreaCode());
                    vo.setItemAccAreaName(accVo.getAreaName());
                    vo.setItemAccBusinessArea(accVo.getBusinessArea());
                    vo.setItemAccGoodsCode(accVo.getGoodsCode());
                    vo.setItemAccGoodsName(accVo.getGoodsName());
                    vo.setItemAccKaCode(accVo.getKaCode());
                    vo.setItemAccKaName(accVo.getKaName());
                    vo.setItemAccKaOrderNumber(accVo.getKaOrderNumber());
                    vo.setItemAccOrderNumber(accVo.getOrderNumber());
                    vo.setItemAccSoldToPartyCode(accVo.getSoldToPartyCode());
                    vo.setItemAccSoldToPartyName(accVo.getSoldToPartyName());
                    vo.setItemAccStoreCode(accVo.getStoreCode());
                    vo.setItemAccStoreName(accVo.getStoreName());
                    vo.setItemAccKaGoodsCode(accVo.getKaGoodsCode());
                    vo.setItemAccKaGoodsName(accVo.getKaGoodsName());
                    vo.setItemAccKaStoreCode(accVo.getKaStoreCode());
                    vo.setItemAccKaStoreName(accVo.getKaStoreName());
                }
                respVos.add(vo);
            }
            exportRespVos.addAll(respVos);
        });
        return exportRespVos;
    }

    public void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {
        BaseAuditFunction baseAuditFunction = this.kmsAuditFunction.functionMap.get(KmsUtils.getConditionEnum(auditTemplateRespVo));
        if (ObjectUtils.isEmpty((Object)baseAuditFunction)) {
            return;
        }
        baseAuditFunction.delayedReceiptAcc(o, auditTemplateRespVo);
    }

    public List<KmsAuditAcceptanceFormRespVo> matchDataSuccList(KmsAuditFormReqVo reqVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo params = new KmsAcceptanceFormReqVo();
        params.setAuditTemplateId(templateRespVo.getId());
        params.setAuditIds(reqVo.getIds());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = this.kmsAcceptanceFormMapper.findMatchedSuccPDS(params);
        acceptanceFormSuccRespVos.forEach(a -> a.setId(a.getGoodsId()));
        return acceptanceFormSuccRespVos;
    }
}

