/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.grabrule.helper;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.grabrule.model.KmsGrabRuleParamEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleStoreEntity;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.base.BaseDateFlagConstants;
import com.biz.crm.nebular.kms.confadmin.base.ComomStatus;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleParamReqVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KmsGrabRuleHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsGrabRuleHelper.class);
    @Resource
    private IKmsAdminService kmsAdminService;
    @Resource
    private IKmsTenantryDirectCustomerOrgService kmsTenantryDirectCustomerOrgService;

    public void check(KmsGrabRuleReqVo reqVo) {
        List ruleParamReqVos;
        AssertUtils.isNotNull((Object)reqVo.getStartTime(), (String)"\u5f00\u59cb\u65f6\u95f4[startTime]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4[endTime]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getIntervalTime(), (String)"\u65f6\u95f4\u95f4\u9694[intervalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbId[bsDirectSystemId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801[bsDirectSystemCode]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0[bsDirectSystemName]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getAccountId(), (String)"\u767b\u5f55\u8d26\u53f7ID[accountId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrderType(), (String)"\u5355\u636e\u7c7b\u578borderType\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getFileDownloadWay(), (String)"\u5355\u636e\u4e0b\u8f7d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getFileClassify(), (String)"\u5355\u636e\u4e0b\u8f7d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getOrderDownloadWay(), (String)"\u5355\u636e\u4e0b\u8f7d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getRuleName(), (String)"\u6293\u5355\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String isAllStore = reqVo.getIsAllStore();
        AssertUtils.isNotEmpty((String)reqVo.getIsAllStore(), (String)"\u662f\u5426\u5168\u90e8\u95e8\u5e97\u6807\u793a\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)isAllStore) && !YesNoEnum.yesNoEnum.YES.getValue().equals(isAllStore) && !YesNoEnum.yesNoEnum.NO.getValue().equals(isAllStore)) {
            throw new BusinessException("\u662f\u5426\u5168\u90e8\u95e8\u5e97\u6807\u793a\u6570\u636e\u9519\u8bef\uff08Y/N\uff09");
        }
        List storeReqVos = reqVo.getRuleStoreList();
        if (YesNoEnum.yesNoEnum.NO.getValue().equals(isAllStore)) {
            if (CollectionUtil.listEmpty((List)storeReqVos)) {
                throw new BusinessException("\u6293\u5355\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            }
            storeReqVos.forEach(o -> AssertUtils.isNotEmpty((String)o.getKmsStoreId(), (String)"\u6293\u5355\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(ruleParamReqVos = reqVo.getRuleParamList()))) {
            ruleParamReqVos.forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getFieldId(), (String)"\u53c2\u6570\u4e3b\u952efieldId\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getFieldEn(), (String)"\u6293\u5355\u5c5e\u6027\u540d[fieldEn]\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getFieldCn(), (String)"\u6293\u5355\u5c5e\u6027\u63cf\u8ff0[fieldCn]\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
    }

    public List<KmsGrabRuleStoreEntity> buildRuleStore(KmsGrabRuleReqVo reqVo) {
        return reqVo.getRuleStoreList().stream().map(o -> {
            o.setGrabRuleId(reqVo.getId());
            return (KmsGrabRuleStoreEntity)CrmBeanUtil.copy((Object)o, KmsGrabRuleStoreEntity.class);
        }).collect(Collectors.toList());
    }

    public List<KmsGrabRuleParamEntity> saveGrabRuleParams(KmsGrabRuleReqVo reqVo) {
        Map paramRespVoMap;
        List<Object> ruleParamEntities = Lists.newArrayList();
        List ruleParamReqVos = reqVo.getRuleParamList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ruleParamReqVos)) {
            KmsTenantryDirectCustomerOrgEntity directCustomerOrgEntity = (KmsTenantryDirectCustomerOrgEntity)((LambdaQueryChainWrapper)this.kmsTenantryDirectCustomerOrgService.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getBsDirectSystemId())).one();
            BsGrabInterfaceParamReqVo params = new BsGrabInterfaceParamReqVo();
            params.setDirectId(directCustomerOrgEntity.getDirectId());
            params.setOrderType(reqVo.getOrderType());
            List<BsGrabInterfaceParamRespVo> grabOrderParams = this.kmsAdminService.findGrabOrderParams(params);
            paramRespVoMap = grabOrderParams.stream().collect(Collectors.toMap(BsGrabInterfaceParamRespVo::getFieldId, Function.identity()));
            if (grabOrderParams.size() != ruleParamReqVos.size()) {
                throw new BusinessException("\u53c2\u6570\u6570\u91cf\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u53c2\u6570\u4fe1\u606f!");
            }
        } else {
            throw new BusinessException("\u6293\u5355\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ruleParamEntities = ruleParamReqVos.stream().map(o -> {
            BsGrabInterfaceParamRespVo paramRespVo = (BsGrabInterfaceParamRespVo)paramRespVoMap.get(o.getFieldId());
            if (ComomStatus.YES.equals((Object)paramRespVo.getIsRequired()) && StringUtils.isEmpty((String)o.getFieldValue())) {
                throw new BusinessException("\u53c2\u6570[" + o.getFieldCn() + "]\u4e3a\u5fc5\u586b\u5b57\u6bb5!");
            }
            o.setGrabRuleId(reqVo.getId());
            if (BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify()) || BaseClassifyConstants.FieldClassify.DATERANGE.getValue().equals(o.getFieldClassify())) {
                this.dateHandle((KmsGrabRuleParamReqVo)o);
            }
            return (KmsGrabRuleParamEntity)CrmBeanUtil.copy((Object)o, KmsGrabRuleParamEntity.class);
        }).collect(Collectors.toList());
        return ruleParamEntities;
    }

    protected void dateHandle(KmsGrabRuleParamReqVo field) {
        List subOptions = field.getSubOptions();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)subOptions)) {
            if (StringUtils.isNotEmpty((String)field.getFieldValue())) {
                Instant now = Instant.now();
                subOptions.forEach(y -> {
                    if (BaseDateFlagConstants.DateFlagClassify.START.getValue().equals(y.getDateFlagClassify())) {
                        field.setStartTimeFieldEn(y.getOptionValue());
                    } else if (BaseDateFlagConstants.DateFlagClassify.END.getValue().equals(y.getDateFlagClassify())) {
                        field.setEndTimeFieldEn(y.getOptionValue());
                    }
                });
            }
        } else {
            throw new BusinessException("subOptions\u5b50\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public XxlJobInfoReqVo buildXxlJobInfo(KmsGrabRuleReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        XxlJobInfoReqVo xxlJobInfoReqVo = new XxlJobInfoReqVo();
        xxlJobInfoReqVo.setJobDesc(reqVo.getRuleName());
        xxlJobInfoReqVo.setAuthor(userRedis.getUsername());
        xxlJobInfoReqVo.setScheduleConf(KmsGrabRuleHelper.buildCron(reqVo));
        return xxlJobInfoReqVo;
    }

    protected static String buildCron(KmsGrabRuleReqVo reqVo) {
        Integer startTime = reqVo.getStartTime();
        Integer endTime = reqVo.getEndTime();
        Integer intervalTime = reqVo.getIntervalTime();
        if (startTime < 0 || startTime > 23 || endTime < 0 || endTime > 23 || startTime >= endTime) {
            throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u89c4\u8303\u9519\u8bef(0-23)");
        }
        if (intervalTime <= 0) {
            throw new BusinessException("\u65f6\u95f4\u95f4\u9694\u5fc5\u987b\u5927\u4e8e\u96f6");
        }
        int minute = 60;
        int quotient = intervalTime / minute;
        int remainder = intervalTime % minute;
        if (quotient == 0) {
            endTime = endTime - 1;
            int gap = (endTime - startTime) * minute;
            if (intervalTime > gap) {
                throw new BusinessException("\u65f6\u95f4\u95f4\u9694\u9519\u8bef!");
            }
            String hour = startTime == endTime ? startTime.toString() : startTime + "-" + endTime;
            String cron = "0 0/" + remainder + " " + hour + " * * ?";
            return cron;
        }
        int gap = (endTime - startTime) * minute;
        if (intervalTime > gap) {
            throw new BusinessException("\u65f6\u95f4\u95f4\u9694\u9519\u8bef!");
        }
        if (remainder == 0) {
            ArrayList hours = Lists.newArrayList();
            int j = endTime;
            for (int i = startTime.intValue(); i <= j; i += quotient) {
                hours.add(String.valueOf(i));
            }
            String hour = hours.stream().collect(Collectors.joining(","));
            String cron = "0 0 " + hour + " * * ?";
            return cron;
        }
        endTime = endTime - 1;
        ArrayList hours = Lists.newArrayList();
        int j = endTime;
        for (int i = startTime.intValue(); i <= j; i += quotient) {
            hours.add(String.valueOf(i));
        }
        String hour = hours.stream().collect(Collectors.joining(","));
        String cron = "0 " + remainder + " " + hour + " * * ?";
        return cron;
    }
}

