/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.grabrule.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsLoggerDataProcessMapper;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.nebular.kms.grabrule.req.KmsLoggerDataProcessReqVo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsLoggerDataProcessHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsLoggerDataProcessHelper.class);
    @Resource
    private KmsLoggerDataProcessMapper kmsLoggerDataProcessMapper;

    public KmsLoggerDataProcessEntity buildEntity(KmsLoggerDataProcessReqVo reqVo) {
        String msg = "";
        String resultStr = reqVo.getResultStr();
        JSONObject result = JSONObject.parseObject((String)resultStr);
        JSONObject reqObject = result.getJSONObject("reqObject");
        JSONObject respObject = result.getJSONObject("respObject");
        JSONObject reqParm = reqObject.getJSONObject("body").getJSONObject("extend_args").getJSONObject("req_parm");
        JSONObject extendParm = reqObject.getJSONObject("body").getJSONObject("extend_args").getJSONObject("extend_parm");
        String doc = reqParm.getString("doc");
        String kaName = reqParm.getString("ka_name");
        String style = extendParm.getString("style");
        String loginAcc = reqParm.getString("username");
        String ruleName = extendParm.getString("rule_name");
        String tenantryId = extendParm.getString("tenantry_id");
        String nickName = extendParm.getString("nick_name");
        String trackId = extendParm.getString("track_id");
        String rawDataId = extendParm.getString("resp_data_id");
        String bsDirectSystemId = extendParm.getString("direct_system_id");
        String grabState = KmsEnum.GrabState.SUCCEED.getValue();
        if (StringUtils.isEmpty((Object)respObject)) {
            msg = "\u6ca1\u6709\u8fd4\u56de\u6b63\u5e38\u7684\u6293\u5355\u7ed3\u679c\u7ed3\u6784\uff08AI\u95ee\u9898\uff09";
            grabState = KmsEnum.GrabState.FAILED.getValue();
        }
        if (!respObject.containsKey((Object)"result")) {
            msg = "\u8fd4\u56de\u7ed3\u6784\u4e2d\u6ca1\u6709result\uff08AI\u95ee\u9898\uff09," + respObject.getString("error_msg");
            grabState = KmsEnum.GrabState.FAILED.getValue();
        } else {
            JSONArray form;
            JSONObject resultObject = respObject.getJSONObject("result");
            Integer login = resultObject.getInteger("login");
            JSONArray errors = resultObject.getJSONArray("errors");
            JSONObject info = resultObject.getJSONObject("info");
            Integer totalNum = info.getInteger("total_num");
            Integer successNum = info.getInteger("succeed");
            Integer dittoNum = info.getInteger("ditto");
            if (login == 0) {
                msg = "\u767b\u5f55\u5931\u8d25,\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";
                grabState = KmsEnum.GrabState.FAILED.getValue();
            }
            if (CollectionUtils.isEmpty((Collection)(form = resultObject.getJSONArray("form"))) && CollectionUtils.isEmpty((Collection)errors)) {
                JSONArray array = new JSONArray();
                msg = dittoNum == 0 ? "KA\u7f51\u7ad9\u5728\u5f53\u524d\u6761\u4ef6\u4e0b\u6ca1\u6709\u5355\u636e" : "KA\u7f51\u7ad9\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e0b\u5355\u636e\u5168\u90e8\u91cd\u590d";
            }
            if (CollectionUtils.isEmpty((Collection)form) && !CollectionUtils.isEmpty((Collection)errors)) {
                msg = errors.toJSONString();
                grabState = KmsEnum.GrabState.FAILED.getValue();
            }
            if (StringUtils.isEmpty((Object)msg)) {
                msg = "\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e0b\u6210\u529f\u6293\u53d6" + successNum + "\u6761\u6570\u636e\uff0c\u53bb\u6389\u91cd\u590d\u6570\u636e" + dittoNum + "\u6761";
            }
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsLoggerDataProcessEntity::getRawDataId, (Object)rawDataId);
        List processEntities = this.kmsLoggerDataProcessMapper.selectList((Wrapper)queryWrapper);
        KmsLoggerDataProcessEntity entity = processEntities.stream().findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)entity)) {
            entity = new KmsLoggerDataProcessEntity();
            entity.setOrderTypeName(doc);
            entity.setBsDirectSystemId(bsDirectSystemId);
            entity.setGrabState(grabState);
            entity.setKaName(kaName);
            entity.setLoginAcc(loginAcc);
            entity.setNickName(nickName);
            entity.setRawDataId(rawDataId);
            entity.setRuleName(ruleName);
            entity.setStyle(style);
            entity.setTenantryId(tenantryId);
            entity.setGrabMessage(msg);
        } else {
            entity.setGrabMessage(msg);
            if (!entity.getGrabState().equals(grabState)) {
                entity.setGrabState(grabState);
            }
        }
        return entity;
    }
}

