/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.grabrule.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsGrabRuleParamMapper;
import com.biz.crm.grabrule.mapper.KmsGrabRuleStoreMapper;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleParamEntity;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.grabrule.model.KmsRequestEntity;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.base.BaseDateFlagConstants;
import com.biz.crm.nebular.kms.confadmin.base.ComomStatus;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleParamReqVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleParamRespVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleStoreRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class KmsRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsRequestHelper.class);
    @Resource
    private KmsGrabRuleParamMapper kmsGrabRuleParamMapper;
    @Resource
    private KmsGrabRuleStoreMapper kmsGrabRuleStoreMapper;
    @Resource
    private IKmsAdminService kmsAdminService;
    @Resource
    private IKmsTenantryDirectCustomerOrgService kmsTenantryDirectCustomerOrgService;
    @Resource
    private KmsConfig kmsConfig;

    public JSONObject buildReqPams(String grabRuleEntityId) {
        JSONObject reqParm = new JSONObject();
        LambdaQueryWrapper paramEntityWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsGrabRuleParamEntity::getGrabRuleId, (Object)grabRuleEntityId);
        List ruleParamEntities = this.kmsGrabRuleParamMapper.selectList((Wrapper)paramEntityWrapper);
        if (!CollectionUtils.isEmpty((Collection)ruleParamEntities)) {
            ruleParamEntities.forEach(o -> {
                if (!org.springframework.util.StringUtils.isEmpty((Object)o.getStartTimeFieldEn()) || !org.springframework.util.StringUtils.isEmpty((Object)o.getEndTimeFieldEn())) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)o.getStartTimeFieldEn())) {
                        Calendar cl = Calendar.getInstance();
                        cl.add(5, Integer.parseInt(o.getFieldValue()) * -1);
                        Date todayStartTime = DateUtil.getTodayStartTime((Date)cl.getTime());
                        reqParm.put(o.getStartTimeFieldEn(), (Object)String.valueOf(todayStartTime.getTime()));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)o.getEndTimeFieldEn())) {
                        reqParm.put(o.getEndTimeFieldEn(), (Object)String.valueOf(DateUtil.getTodayEndTime((Date)new Date()).getTime()));
                    }
                } else {
                    reqParm.put(o.getFieldEn(), (Object)(org.springframework.util.StringUtils.isEmpty((Object)o.getFieldValue()) ? "" : o.getFieldValue()));
                }
            });
        }
        return reqParm;
    }

    public void buildReqPamStore(JSONObject reqParm, String grabRuleEntityId, String isAllStore) {
        ArrayList storeList = new ArrayList();
        if (YesNoEnum.yesNoEnum.NO.getValue().equals(isAllStore)) {
            reqParm.put("kms_all_store", (Object)"false");
            List<KmsGrabRuleStoreRespVo> directStoreRespVos = this.kmsGrabRuleStoreMapper.findByGrabRuleId(grabRuleEntityId);
            directStoreRespVos.forEach(x -> {
                HashMap<String, String> storeMap = new HashMap<String, String>(2);
                storeMap.put("code", x.getStoreCode());
                storeMap.put("name", x.getStoreName());
                storeList.add(storeMap);
            });
        } else {
            reqParm.put("kms_all_store", (Object)"true");
            HashMap<String, String> storeMap = new HashMap<String, String>(2);
            storeMap.put("code", "");
            storeMap.put("name", "");
            storeList.add(storeMap);
        }
        reqParm.put("sold_to_party", storeList);
    }

    public void buildCommonReqPams(JSONObject reqParm, KmsGrabRuleRespVo grabRuleRespVo) {
        reqParm.put("ka_name", (Object)grabRuleRespVo.getBsDirectSystemName());
        reqParm.put("doc", KmsAdminEnum.OrderType.GETMAP.get(grabRuleRespVo.getOrderType()));
        reqParm.put("username", (Object)grabRuleRespVo.getLoginAcc());
        reqParm.put("password", (Object)grabRuleRespVo.getLoginPass());
        reqParm.put("KMS_path_type", (Object)this.kmsConfig.getKaFlag());
        reqParm.put("kms_ip", (Object)"");
        reqParm.put("principal_id", (Object)grabRuleRespVo.getCreateName());
        reqParm.put("force", (Object)"0");
        reqParm.put("tenantry_id", (Object)this.kmsConfig.getTenantryId());
    }

    public JSONObject buildExtendParms(KmsGrabRuleRespVo grabRuleRespVo, String trackId, KmsAdminEnum.AutoType autoType) {
        JSONObject extendParm = new JSONObject();
        extendParm.put("tenantry_id", (Object)this.kmsConfig.getTenantryId());
        extendParm.put("rule_name", (Object)grabRuleRespVo.getRuleName());
        extendParm.put("direct_system_id", (Object)grabRuleRespVo.getBsDirectSystemId());
        extendParm.put("bs_invoice_id", (Object)grabRuleRespVo.getOrderTypeId());
        extendParm.put("ka_flag", (Object)this.kmsConfig.getKaFlag());
        extendParm.put("track_id", (Object)trackId);
        extendParm.put("style", (Object)autoType.getDescription());
        extendParm.put("nick_name", (Object)grabRuleRespVo.getNickName());
        extendParm.put("resp_data_id", (Object)grabRuleRespVo.getRawDataId());
        return extendParm;
    }

    public JSONObject buildRequest(JSONObject reqParm, JSONObject extendParm) {
        JSONObject inputFile = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"");
        inputFile.put("file_names", (Object)jsonArray);
        inputFile.put("file_type", (Object)"url");
        JSONObject extendArgs = new JSONObject();
        extendArgs.put("req_parm", (Object)reqParm);
        extendArgs.put("extend_parm", (Object)extendParm);
        JSONObject body = new JSONObject();
        body.put("extend_args", (Object)extendArgs);
        body.put("input_file", (Object)inputFile);
        JSONObject request = new JSONObject();
        request.put("app_id", (Object)"ka_grab_order");
        request.put("body", (Object)body);
        return request;
    }

    public KmsRequestEntity buildRequestEntity(KmsGrabRuleRespVo grabRuleRespVo, JSONObject request, KmsAdminEnum.AutoType autoType) {
        KmsRequestEntity entity = new KmsRequestEntity();
        entity.setAuto(autoType.getValue());
        entity.setFile(KmsAdminEnum.FileType.DATA.getValue());
        entity.setTime(LocalDateTime.now());
        entity.setResponse("");
        entity.setUuid(UUID.randomUUID().toString().replaceAll("-", ""));
        entity.setFail(Integer.valueOf(0));
        entity.setMethod(grabRuleRespVo.getOrderDownloadWay());
        entity.setRequest(request.toJSONString());
        return entity;
    }

    public KmsDataAuthEntity buildAuthEntity(KmsGrabRuleRespVo grabRuleRespVo) {
        KmsDataAuthEntity authEntity = (KmsDataAuthEntity)CrmBeanUtil.copy((Object)grabRuleRespVo, KmsDataAuthEntity.class);
        authEntity.setBsDirectSystemId(grabRuleRespVo.getBsDirectSystemId());
        authEntity.setRespDataId(grabRuleRespVo.getRawDataId());
        authEntity.setId(null);
        return authEntity;
    }

    public KmsLoggerDataProcessEntity buildLogger(KmsGrabRuleRespVo grabRuleRespVo, KmsAdminEnum.AutoType auto) {
        KmsLoggerDataProcessEntity loggerEntity = new KmsLoggerDataProcessEntity();
        loggerEntity.setOrderTypeName((String)KmsAdminEnum.OrderType.GETMAP.get(grabRuleRespVo.getOrderType()));
        loggerEntity.setBsDirectSystemId(grabRuleRespVo.getBsDirectSystemId());
        loggerEntity.setKaName(grabRuleRespVo.getBsDirectSystemName());
        loggerEntity.setLoginAcc(grabRuleRespVo.getLoginAcc());
        loggerEntity.setNickName(grabRuleRespVo.getNickName());
        loggerEntity.setRawDataId(grabRuleRespVo.getRawDataId());
        loggerEntity.setRuleName(grabRuleRespVo.getRuleName());
        loggerEntity.setStyle(auto.getDescription());
        loggerEntity.setTenantryId(this.kmsConfig.getTenantryId());
        loggerEntity.setGrabState(KmsEnum.GrabState.GRAB_ING.getValue());
        return loggerEntity;
    }

    public JSONObject buildManualGrabReqPams(KmsGrabRuleReqVo reqVo) {
        Map paramRespVoMap;
        List<Object> ruleParamEntities = Lists.newArrayList();
        List ruleParamReqVos = reqVo.getRuleParamList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ruleParamReqVos)) {
            KmsTenantryDirectCustomerOrgEntity directCustomerOrgEntity = (KmsTenantryDirectCustomerOrgEntity)((LambdaQueryChainWrapper)this.kmsTenantryDirectCustomerOrgService.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getBsDirectSystemId())).one();
            BsGrabInterfaceParamReqVo params = new BsGrabInterfaceParamReqVo();
            params.setDirectId(directCustomerOrgEntity.getDirectId());
            params.setOrderType(reqVo.getOrderType());
            List<BsGrabInterfaceParamRespVo> grabOrderParams = this.kmsAdminService.findGrabOrderParams(params);
            paramRespVoMap = grabOrderParams.stream().collect(Collectors.toMap(BsGrabInterfaceParamRespVo::getFieldId, Function.identity()));
            if (grabOrderParams.size() != ruleParamReqVos.size()) {
                throw new BusinessException("\u53c2\u6570\u6570\u91cf\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u53c2\u6570\u4fe1\u606f!");
            }
        } else {
            throw new BusinessException("\u6293\u5355\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ruleParamEntities = ruleParamReqVos.stream().map(o -> {
            BsGrabInterfaceParamRespVo paramRespVo = (BsGrabInterfaceParamRespVo)paramRespVoMap.get(o.getFieldId());
            if (ComomStatus.YES.equals((Object)paramRespVo.getIsRequired()) && StringUtils.isEmpty((String)o.getFieldValue())) {
                throw new BusinessException("\u53c2\u6570[" + o.getFieldCn() + "]\u4e3a\u5fc5\u586b\u5b57\u6bb5!");
            }
            o.setGrabRuleId(reqVo.getId());
            if (BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify()) || BaseClassifyConstants.FieldClassify.DATERANGE.getValue().equals(o.getFieldClassify())) {
                this.dateHandle((KmsGrabRuleParamReqVo)o);
            }
            return (KmsGrabRuleParamRespVo)CrmBeanUtil.copy((Object)o, KmsGrabRuleParamRespVo.class);
        }).collect(Collectors.toList());
        JSONObject reqParm = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)ruleParamEntities)) {
            ruleParamEntities.forEach(o -> {
                if (!org.springframework.util.StringUtils.isEmpty((Object)o.getStartTimeFieldEn()) || !org.springframework.util.StringUtils.isEmpty((Object)o.getEndTimeFieldEn())) {
                    Date date;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)o.getStartTimeFieldEn())) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)o.getStartTime())) {
                            if (!org.springframework.util.StringUtils.isEmpty((Object)o.getFieldValue())) {
                                Calendar cl = Calendar.getInstance();
                                cl.add(5, Integer.parseInt(o.getFieldValue()) * -1);
                                Date todayStartTime = DateUtil.getTodayStartTime((Date)cl.getTime());
                                reqParm.put(o.getStartTimeFieldEn(), (Object)String.valueOf(todayStartTime.getTime()));
                            } else {
                                reqParm.put(o.getStartTimeFieldEn(), (Object)"");
                            }
                        } else {
                            date = DateUtil.getDate((long)Long.parseLong(o.getStartTime()));
                            String startTime = String.valueOf(DateUtil.getTodayStartTime((Date)date).getTime());
                            reqParm.put(o.getStartTimeFieldEn(), (Object)startTime);
                        }
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)o.getEndTimeFieldEn())) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)o.getEndTime())) {
                            if (!org.springframework.util.StringUtils.isEmpty((Object)o.getFieldValue())) {
                                reqParm.put(o.getEndTimeFieldEn(), (Object)String.valueOf(DateUtil.getTodayEndTime((Date)new Date()).getTime()));
                            } else {
                                reqParm.put(o.getEndTimeFieldEn(), (Object)"");
                            }
                        } else {
                            date = DateUtil.getDate((long)Long.parseLong(o.getEndTime()));
                            String endTime = String.valueOf(DateUtil.getTodayEndTime((Date)date).getTime());
                            reqParm.put(o.getEndTimeFieldEn(), (Object)endTime);
                        }
                    }
                } else {
                    reqParm.put(o.getFieldEn(), (Object)(org.springframework.util.StringUtils.isEmpty((Object)o.getFieldValue()) ? "" : o.getFieldValue()));
                }
            });
        }
        return reqParm;
    }

    protected void dateHandle(KmsGrabRuleParamReqVo field) {
        List subOptions = field.getSubOptions();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)subOptions)) {
            throw new BusinessException("subOptions\u5b50\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Instant now = Instant.now();
        subOptions.forEach(y -> {
            if (BaseDateFlagConstants.DateFlagClassify.START.getValue().equals(y.getDateFlagClassify())) {
                field.setStartTimeFieldEn(y.getOptionValue());
                field.setStartTime(y.getSetValue());
            } else if (BaseDateFlagConstants.DateFlagClassify.END.getValue().equals(y.getDateFlagClassify())) {
                field.setEndTimeFieldEn(y.getOptionValue());
                field.setEndTime(y.getSetValue());
            }
        });
    }
}

