/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.grabrule.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectThreadMapper;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.grabrule.helper.KmsGrabRuleHelper;
import com.biz.crm.grabrule.mapper.KmsGrabRuleMapper;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleParamEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleStoreEntity;
import com.biz.crm.grabrule.service.IKmsGrabRuleParamService;
import com.biz.crm.grabrule.service.IKmsGrabRuleService;
import com.biz.crm.grabrule.service.IKmsGrabRuleStoreService;
import com.biz.crm.job.XxlJobFeign;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.nebular.job.resp.XxlJobInfoRespVo;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectThreadRespVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleStoreRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsGrabRuleServiceExpandImpl"})
public class KmsGrabRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsGrabRuleMapper, KmsGrabRuleEntity>
implements IKmsGrabRuleService {
    private static final Logger log = LoggerFactory.getLogger(KmsGrabRuleServiceImpl.class);
    @Resource
    private KmsGrabRuleMapper kmsGrabRuleMapper;
    @Resource
    private IKmsGrabRuleStoreService kmsGrabRuleStoreService;
    @Resource
    private IKmsGrabRuleParamService kmsGrabRuleParamService;
    @Resource
    private IKmsAdminService kmsAdminService;
    @Resource
    private IKmsTenantryDirectCustomerOrgService kmsTenantryDirectCustomerOrgService;
    @Resource
    private XxlJobFeign xxlJobFeign;
    @Resource
    private KmsGrabRuleHelper kmsGrabRuleHelper;
    @Resource
    private KmsDirectThreadMapper kmsDirectThreadMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsGrabRuleRespVo> findList(KmsGrabRuleReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsGrabRuleRespVo> list = this.kmsGrabRuleMapper.findList((Page<KmsGrabRuleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsGrabRuleRespVo query(KmsGrabRuleReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u67e5\u8be2\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleRespVo respVo = this.kmsGrabRuleMapper.findById(reqVo);
        AssertUtils.isNotNull((Object)respVo, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        String ruleId = respVo.getId();
        String isAllStore = respVo.getIsAllStore();
        if (YesNoEnum.yesNoEnum.NO.getValue().equals(isAllStore)) {
            List<KmsGrabRuleStoreRespVo> ruleStoreRespVos = this.kmsGrabRuleStoreService.findByGrabRuleId(ruleId);
            respVo.setRuleStoreList(ruleStoreRespVos);
        }
        KmsDirectThreadRespVo threadRespVo = this.kmsDirectThreadMapper.findByGrabRuleId(ruleId);
        AssertUtils.isNotNull((Object)threadRespVo, (String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\u4e0b\u8f7d\u65b9\u5f0f");
        respVo.setFileClassify(threadRespVo.getFileClassify());
        respVo.setOrderDownloadWay(threadRespVo.getOrderDownloadWay());
        respVo.setFileDownloadWay(threadRespVo.getFileDownloadWay());
        KmsTenantryDirectCustomerOrgEntity directCustomerOrgEntity = (KmsTenantryDirectCustomerOrgEntity)((LambdaQueryChainWrapper)this.kmsTenantryDirectCustomerOrgService.lambdaQuery().eq(BaseIdEntity::getId, (Object)respVo.getBsDirectSystemId())).one();
        BsGrabInterfaceParamReqVo params = new BsGrabInterfaceParamReqVo();
        params.setDirectId(directCustomerOrgEntity.getDirectId());
        respVo.setDirectId(directCustomerOrgEntity.getDirectId());
        params.setOrderType(respVo.getOrderType());
        List<BsGrabInterfaceParamRespVo> grabOrderParams = this.kmsAdminService.findGrabOrderParams(params);
        List grabRuleParamEntities = ((LambdaQueryChainWrapper)this.kmsGrabRuleParamService.lambdaQuery().eq(KmsGrabRuleParamEntity::getGrabRuleId, (Object)ruleId)).list();
        Map paramMap = grabRuleParamEntities.stream().collect(Collectors.toMap(KmsGrabRuleParamEntity::getFieldId, Function.identity()));
        grabOrderParams.forEach(o -> {
            KmsGrabRuleParamEntity pe = (KmsGrabRuleParamEntity)paramMap.get(o.getFieldId());
            if (!ObjectUtils.isEmpty((Object)pe)) {
                o.setFieldValue(pe.getFieldValue());
                o.setOptionName(pe.getOptionName());
            }
        });
        respVo.setRuleParamList(grabOrderParams);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsGrabRuleReqVo reqVo) {
        this.kmsGrabRuleHelper.check(reqVo);
        KmsGrabRuleEntity entity = (KmsGrabRuleEntity)CrmBeanUtil.copy((Object)reqVo, KmsGrabRuleEntity.class);
        this.save(entity);
        KmsGrabRuleRespVo newData = (KmsGrabRuleRespVo)CrmBeanUtil.copy((Object)entity, KmsGrabRuleRespVo.class);
        String grabRuleId = entity.getId();
        reqVo.setId(grabRuleId);
        List ruleStoreReqVos = reqVo.getRuleStoreList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ruleStoreReqVos)) {
            List<KmsGrabRuleStoreEntity> storeEntities = this.kmsGrabRuleHelper.buildRuleStore(reqVo);
            this.kmsGrabRuleStoreService.saveBatch(storeEntities);
            newData.setRuleStoreList(CrmBeanUtil.copyList(storeEntities, KmsGrabRuleStoreRespVo.class));
        }
        List<KmsGrabRuleParamEntity> ruleParamEntities = this.kmsGrabRuleHelper.saveGrabRuleParams(reqVo);
        this.kmsGrabRuleParamService.saveBatch(ruleParamEntities);
        newData.setRuleParamList(CrmBeanUtil.copyList(ruleParamEntities, BsGrabInterfaceParamRespVo.class));
        XxlJobInfoReqVo infoReqVo = this.kmsGrabRuleHelper.buildXxlJobInfo(reqVo);
        infoReqVo.setExecutorParam(grabRuleId);
        XxlJobInfoRespVo xxlJobInfoRespVo = (XxlJobInfoRespVo)ApiResultUtil.objResult((Result)this.xxlJobFeign.add(infoReqVo));
        AssertUtils.isNotNull((Object)xxlJobInfoRespVo, (String)"\u751f\u6210\u4efb\u52a1\u5931\u8d25");
        String taskId = xxlJobInfoRespVo.getId();
        if (ObjectUtils.isEmpty((Object)taskId)) {
            throw new BusinessException("\u751f\u6210\u4efb\u52a1\u5931\u8d25!");
        }
        entity.setTaskId(taskId);
        this.updateById(entity);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsGrabRuleReqVo reqVo) {
        this.kmsGrabRuleHelper.check(reqVo);
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleEntity entity = (KmsGrabRuleEntity)this.getById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)entity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        BeanUtils.copyProperties((Object)reqVo, (Object)entity);
        KmsGrabRuleRespVo oldData = this.query(reqVo);
        this.updateById(entity);
        ((LambdaUpdateChainWrapper)this.kmsGrabRuleStoreService.lambdaUpdate().eq(KmsGrabRuleStoreEntity::getGrabRuleId, (Object)entity.getId())).remove();
        List ruleStoreReqVos = reqVo.getRuleStoreList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ruleStoreReqVos)) {
            List<KmsGrabRuleStoreEntity> storeEntities = this.kmsGrabRuleHelper.buildRuleStore(reqVo);
            this.kmsGrabRuleStoreService.saveBatch(storeEntities);
        }
        ((LambdaUpdateChainWrapper)this.kmsGrabRuleParamService.lambdaUpdate().eq(KmsGrabRuleParamEntity::getGrabRuleId, (Object)entity.getId())).remove();
        List<KmsGrabRuleParamEntity> ruleParamEntities = this.kmsGrabRuleHelper.saveGrabRuleParams(reqVo);
        this.kmsGrabRuleParamService.saveBatch(ruleParamEntities);
        XxlJobInfoReqVo infoReqVo = this.kmsGrabRuleHelper.buildXxlJobInfo(reqVo);
        infoReqVo.setId(entity.getTaskId());
        this.xxlJobFeign.update(infoReqVo);
        KmsGrabRuleRespVo newData = this.query(reqVo);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsGrabRuleReqVo reqVo) {
        List kmsGrabRuleEntities = this.kmsGrabRuleMapper.selectBatchIds(reqVo.getIds());
        List taskIds = kmsGrabRuleEntities.stream().map(KmsGrabRuleEntity::getTaskId).collect(Collectors.toList());
        this.removeByIds(reqVo.getIds());
        Result remove = this.xxlJobFeign.remove(taskIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsGrabRuleReqVo reqVo) {
        List kmsGrabRuleEntities = this.kmsGrabRuleMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsGrabRuleEntities)) {
            kmsGrabRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        List taskIds = kmsGrabRuleEntities.stream().map(KmsGrabRuleEntity::getTaskId).collect(Collectors.toList());
        this.updateBatchById(kmsGrabRuleEntities);
        this.xxlJobFeign.start(taskIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsGrabRuleReqVo reqVo) {
        List kmsGrabRuleEntities = this.kmsGrabRuleMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsGrabRuleEntities)) {
            kmsGrabRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        List taskIds = kmsGrabRuleEntities.stream().map(KmsGrabRuleEntity::getTaskId).collect(Collectors.toList());
        this.updateBatchById(kmsGrabRuleEntities);
        this.xxlJobFeign.pause(taskIds);
    }
}

