/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.jobhandler;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceFormService;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.handler.annotation.XxlJob;
import com.biz.crm.core.xxllog.XxlJobLogger;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.grabrule.service.IKmsRequestService;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsAcceptanceFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsInventoryDataFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsOrderFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsReturnFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsSaleDataFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.orderform.service.IKmsOrderFormService;
import com.biz.crm.rawdata.model.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsInventoryDataFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsOrderFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsReturnFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsSaleDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsAcceptanceFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsInventoryDataFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsOrderFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsReturnFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsSaleDataFormDetailDwService;
import com.biz.crm.returnform.service.IKmsReturnFormService;
import com.biz.crm.salesdata.service.IKmsSalesDataService;
import com.biz.crm.stockdata.service.IKmsStockDataService;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsXxlJob {
    private static final Logger log = LoggerFactory.getLogger(KmsXxlJob.class);
    @Resource
    private IKmsRequestService kmsRequestService;
    @Resource
    private IKmsOrderFormService kmsOrderFormService;
    @Resource
    private IKmsOrderFormDetailDwService kmsOrderFormDetailDwService;
    @Resource
    private IKmsAcceptanceFormService kmsAcceptanceFormService;
    @Resource
    private IKmsAcceptanceFormDetailDwService kmsAcceptanceFormDetailDwService;
    @Resource
    private IKmsReturnFormService kmsReturnFormService;
    @Resource
    private IKmsReturnFormDetailDwService kmsReturnFormDetailDwService;
    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;
    @Resource
    private IKmsAuditFormService kmsAuditFormService;
    @Resource
    private KmsConfig kmsConfig;
    @Resource
    private MdmUserFeign mdmUserFeign;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper tenantryDirectCustomerOrgMapper;
    @Resource
    private IKmsSaleDataFormDetailDwService kmsSaleDataFormDetailDwService;
    @Resource
    private IKmsInventoryDataFormDetailDwService kmsInventoryDataFormDetailDwService;
    @Resource
    private IKmsSalesDataService kmsSalesDataService;
    @Resource
    private IKmsStockDataService kmsStockDataService;

    @XxlJob(value="kmsJobHandler")
    public ReturnT<String> demoJobHandler(String param) {
        try {
            if (!StringUtils.isEmpty((Object)param)) {
                this.kmsRequestService.save(param);
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="kmsOrderFormTransJobHandler")
    public ReturnT<String> kmsOrderFormTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            KmsOrderFormDetailDwReqVo params = new KmsOrderFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsOrderFormDetailDwRespVo> dwRespVos = this.kmsOrderFormDetailDwService.findNotTransData(params);
            dwRespVos.forEach(o -> {
                try {
                    this.kmsOrderFormService.autoTransData((KmsOrderFormDetailDwRespVo)o);
                }
                catch (Exception e) {
                    sb.append("\u5355\u636e[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + KmsXxlJob.stackMsg(e.getStackTrace(), null) + " | ");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsOrderFormDetailDwService.lambdaUpdate().eq(KmsOrderFormDetailDwEntity::getOrderNumber, (Object)o.getOrderNumber())).set(KmsOrderFormDetailDwEntity::getTransStatus, (Object)"-1")).update();
                }
            });
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    @XxlJob(value="kmsAcceptanceFormTransJobHandler")
    public ReturnT<String> kmsAcceptanceFormTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            KmsAcceptanceFormDetailDwReqVo params = new KmsAcceptanceFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsAcceptanceFormDetailDwRespVo> dwRespVos = this.kmsAcceptanceFormDetailDwService.findNotTransData(params);
            dwRespVos.forEach(o -> {
                try {
                    this.kmsAcceptanceFormService.autoTransData((KmsAcceptanceFormDetailDwRespVo)o);
                }
                catch (Exception e) {
                    sb.append("\u5355\u636e[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + KmsXxlJob.stackMsg(e.getStackTrace(), null) + " | ");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsAcceptanceFormDetailDwService.lambdaUpdate().eq(KmsAcceptanceFormDetailDwEntity::getOrderNumber, (Object)o.getOrderNumber())).set(KmsAcceptanceFormDetailDwEntity::getTransStatus, (Object)"-1")).update();
                }
            });
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    @XxlJob(value="kmsReturnFormTransJobHandler")
    public ReturnT<String> kmsReturnFormTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            KmsReturnFormDetailDwReqVo params = new KmsReturnFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsReturnFormDetailDwRespVo> orderNumbers = this.kmsReturnFormDetailDwService.findNotTransData(params);
            orderNumbers.forEach(o -> {
                try {
                    this.kmsReturnFormService.autoTransData((KmsReturnFormDetailDwRespVo)o);
                }
                catch (Exception e) {
                    sb.append("\u5355\u636e[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + KmsXxlJob.stackMsg(e.getStackTrace(), null) + " | ");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsReturnFormDetailDwService.lambdaUpdate().eq(KmsReturnFormDetailDwEntity::getOrderNumber, (Object)o.getOrderNumber())).set(KmsReturnFormDetailDwEntity::getTransStatus, (Object)"-1")).update();
                }
            });
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    @XxlJob(value="kmsSaleDataTransJobHandler")
    public ReturnT<String> kmsSaleDataTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            KmsSaleDataFormDetailDwReqVo params = new KmsSaleDataFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsSaleDataFormDetailDwRespVo> detailDwRespVos = this.kmsSaleDataFormDetailDwService.findNotTransData(params);
            detailDwRespVos.forEach(o -> {
                try {
                    this.kmsSalesDataService.autoTransData((KmsSaleDataFormDetailDwRespVo)o);
                }
                catch (Exception e) {
                    sb.append("\u5355\u636e[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + KmsXxlJob.stackMsg(e.getStackTrace(), null) + " | ");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsSaleDataFormDetailDwService.lambdaUpdate().eq(KmsSaleDataFormDetailDwEntity::getOrderNumber, (Object)o.getOrderNumber())).set(KmsSaleDataFormDetailDwEntity::getTransStatus, (Object)"-1")).update();
                }
            });
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    @XxlJob(value="kmsStockDataTransJobHandler")
    public ReturnT<String> kmsStockDataTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            KmsInventoryDataFormDetailDwReqVo params = new KmsInventoryDataFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsInventoryDataFormDetailDwRespVo> orderNumbers = this.kmsInventoryDataFormDetailDwService.findNotTransData(params);
            orderNumbers.forEach(o -> {
                try {
                    this.kmsStockDataService.autoTransData((KmsInventoryDataFormDetailDwRespVo)o);
                }
                catch (Exception e) {
                    sb.append("\u5355\u636e[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + KmsXxlJob.stackMsg(e.getStackTrace(), null) + " | ");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsInventoryDataFormDetailDwService.lambdaUpdate().eq(KmsInventoryDataFormDetailDwEntity::getOrderNumber, (Object)o.getOrderNumber())).set(KmsInventoryDataFormDetailDwEntity::getTransStatus, (Object)"-1")).update();
                }
            });
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    @XxlJob(value="kmsPullSapJobHandler")
    public ReturnT<String> pullSap(String param) {
        StringBuilder sb = new StringBuilder("");
        try {
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            templateReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            List<KmsAuditTemplateRespVo> auditTemplateRespAll = this.kmsAuditTemplateService.findAll(templateReqVo);
            List<KmsAuditTemplateRespVo> templateRespVos = auditTemplateRespAll.stream().filter(o -> !CollectionUtils.isEmpty((Collection)o.getDirectVos())).collect(Collectors.toList());
            AssertUtils.isNotEmpty(templateRespVos, (String)"\u672a\u67e5\u8be2\u5230\u6a21\u7248\u4fe1\u606f");
            KmsSapOrderFormReqVo kmsSapOrderFormReqVo = new KmsSapOrderFormReqVo();
            Calendar cl = Calendar.getInstance();
            cl.add(5, -1);
            kmsSapOrderFormReqVo.setInvoiceCreateTime(DateUtil.formatDate((Calendar)cl));
            HashMap customerOrgRespVoMap = Maps.newHashMap();
            templateRespVos.forEach(o -> {
                try {
                    String token = UUID.randomUUID().toString().replaceAll("-", "");
                    UserUtils.createUserToRedis((String)token, (String)o.getCreateCode(), (String)o.getCreatePosCode(), (String)LoginFromTypeEnum.TEMPORARY.getValue(), (long)3600L);
                    MdmOrgRespVo companyOrg = KmsOrgUtil.getCompanyOrg(o.getCreateOrgCode());
                    AssertUtils.isNotNull((Object)companyOrg, (String)("\u6a21\u7248[" + o.getTemplateName() + "]\u6ca1\u6709\u6240\u5c5e\u516c\u53f8\u4fe1\u606f!"));
                    o.setSapOrgCode(companyOrg.getSapOrgCode());
                    o.setOrgCode(companyOrg.getOrgCode());
                    ConcurrentHashMap map = ThreadLocalUtil.get();
                    map.put("functionCode", this.kmsConfig.getFunctionCode());
                    map.put("menuCode", this.kmsConfig.getMenuCode());
                    templateReqVo.setId(o.getId());
                    List<KmsAuditTemplateRespVo> auditTemplate = this.kmsAuditTemplateService.findAll(templateReqVo);
                    KmsAuditTemplateRespVo auditTemplateRespVo = auditTemplate.get(0);
                    auditTemplateRespVo.setSapOrgCode(companyOrg.getSapOrgCode());
                    auditTemplateRespVo.setOrgCode(companyOrg.getOrgCode());
                    ArrayList auditTemplateRespVos = Lists.newArrayList();
                    auditTemplateRespVos.add(auditTemplateRespVo);
                    auditTemplateRespVo.getDirectVos().forEach(ka -> {
                        try {
                            KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
                            customerOrgReqVo.setDirectId(ka.getDirectId());
                            customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                            List<KmsTenantryDirectCustomerOrgRespVo> customerOrgMapperList = this.tenantryDirectCustomerOrgMapper.findList(customerOrgReqVo);
                            customerOrgMapperList.forEach(c -> {
                                kmsSapOrderFormReqVo.setBsDirectSystemId(c.getId());
                                kmsSapOrderFormReqVo.setAuditTemplateVo(auditTemplateRespVos);
                                KmsTenantryDirectCustomerOrgRespVo cuOrg = (KmsTenantryDirectCustomerOrgRespVo)customerOrgRespVoMap.get(c.getBsDirectSystemId());
                                if (ObjectUtils.isEmpty((Object)cuOrg)) {
                                    this.kmsAuditFormService.pullSap(kmsSapOrderFormReqVo);
                                    customerOrgRespVoMap.put(c.getBsDirectSystemId(), c);
                                }
                                if (!CollectionUtils.isEmpty((Collection)kmsSapOrderFormReqVo.getInvoiceIds())) {
                                    this.kmsAuditFormService.pullSapSummary(kmsSapOrderFormReqVo);
                                }
                            });
                        }
                        catch (Exception e) {
                            sb.append(e.getMessage() + " | \u6a21\u7248[" + o.getTemplateName() + "]\u5546\u8d85[" + ka.getDirectName() + "]\u6293\u53d6SAP\u5931\u8d25");
                        }
                    });
                }
                catch (Exception e) {
                    sb.append(e.getMessage() + " | \u6a21\u7248[" + o.getTemplateName() + "]\u6293\u53d6SAP\u5931\u8d25");
                }
                finally {
                    ThreadLocalUtil.delObj();
                    ThreadLocalUtil.deleteUser();
                }
            });
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    @XxlJob(value="kmsAuditFormMatchJobHandler")
    public ReturnT<String> kmsAuditFormMatchJobHandler(String param) {
        StringBuilder sb = new StringBuilder("");
        try {
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            templateReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            List<KmsAuditTemplateRespVo> auditTemplateRespAll = this.kmsAuditTemplateService.findAll(templateReqVo);
            List<KmsAuditTemplateRespVo> templateRespVos = auditTemplateRespAll.stream().filter(o -> !CollectionUtils.isEmpty((Collection)o.getDirectVos())).collect(Collectors.toList());
            AssertUtils.isNotEmpty(templateRespVos, (String)"\u672a\u67e5\u8be2\u5230\u6a21\u7248\u4fe1\u606f");
            KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
            int j = 0;
            for (int i = -2; i <= j; ++i) {
                Calendar cl = Calendar.getInstance();
                cl.add(5, i);
                formReqVo.setCreateDate(DateUtil.formatDate((Calendar)cl));
                templateRespVos.forEach(o -> {
                    try {
                        String token = UUID.randomUUID().toString().replaceAll("-", "");
                        UserUtils.createUserToRedis((String)token, (String)o.getCreateCode(), (String)o.getCreatePosCode(), (String)LoginFromTypeEnum.TEMPORARY.getValue(), (long)3600L);
                        ConcurrentHashMap map = ThreadLocalUtil.get();
                        map.put("functionCode", this.kmsConfig.getFunctionCode());
                        map.put("menuCode", this.kmsConfig.getMenuCode());
                        formReqVo.setAuditTemplateId(o.getId());
                        formReqVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
                        formReqVo.setAuditResult(KmsEnum.AuditStatus.WAIT.getValue());
                        formReqVo.setDesc("ASC");
                        templateReqVo.setId(o.getId());
                        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
                        templateRespVo.getDirectVos().forEach(dir -> {
                            formReqVo.setBsDirectSystemId(dir.getBsDirectSystemId());
                            List<KmsAuditFormRespVo> kmsAuditFormRespVos = this.kmsAuditFormService.findWaitList(formReqVo);
                            kmsAuditFormRespVos.forEach(afVo -> {
                                try {
                                    this.kmsAuditFormService.auditMatch((KmsAuditFormRespVo)afVo, templateRespVo);
                                    o.setRemarks("\u5ef6\u8fdf\u6536\u8d27");
                                    this.kmsAuditFormService.delayedReceipt((KmsAuditFormRespVo)afVo, templateRespVo);
                                }
                                catch (Exception e) {
                                    log.info(dir.getBsDirectSystemCode() + "-" + afVo.getAuditNumber() + "\u5339\u914d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                                    sb.append(e.getMessage() + " | ");
                                }
                            });
                        });
                    }
                    catch (Exception e) {
                        sb.append(e.getMessage() + "-" + KmsXxlJob.stackMsg(e.getStackTrace(), null) + " | ");
                    }
                    finally {
                        ThreadLocalUtil.delObj();
                        ThreadLocalUtil.deleteUser();
                    }
                });
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty((Object)msg)) {
            return ReturnT.SUCCESS;
        }
        XxlJobLogger.log((String)("\u5931\u8d25\u4fe1\u606f\uff1a" + msg), (Object[])new Object[0]);
        return ReturnT.FAIL;
    }

    public static String stackMsg(StackTraceElement[] stackTraceElements, String filtration) {
        if (null == stackTraceElements || stackTraceElements.length < 1) {
            return null;
        }
        StringBuffer upMethodName = new StringBuffer();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filtration) && !stackTraceElement.getClassName().startsWith(filtration)) continue;
            upMethodName.append("\n\t res ");
            upMethodName.append(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
        return upMethodName.toString();
    }
}

