/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kaproduct.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.kaproduct.mapper.KmsProductUnitMapper;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kaproduct.model.KmsProductUnitEntity;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.kaproduct.service.IKmsProductUnitService;
import com.biz.crm.kaproduct.service.IKmsTenantryDirectProductService;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductForExportRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductUnitRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsTenantryDirectProductServiceExpandImpl"})
public class KmsTenantryDirectProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsTenantryDirectProductMapper, KmsTenantryDirectProductEntity>
implements IKmsTenantryDirectProductService {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectProductServiceImpl.class);
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;
    @Resource
    private IKmsProductUnitService kmsProductUnitService;
    @Resource
    private KmsProductUnitMapper kmsProductUnitMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsTenantryDirectProductRespVo> findList(KmsTenantryDirectProductReqVo reqVo) {
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsTenantryDirectProductRespVo> list = this.kmsTenantryDirectProductMapper.findList((Page<KmsTenantryDirectProductRespVo>)page, reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsTenantryDirectProductRespVo query(KmsTenantryDirectProductReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsTenantryDirectProductRespVo respVo = this.kmsTenantryDirectProductMapper.findById(reqVo.getId());
        AssertUtils.isNotNull((Object)respVo, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        List productUnitEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.kmsProductUnitService.lambdaQuery().eq(KmsProductUnitEntity::getTenantryDirectProductId, (Object)respVo.getId())).orderByAsc(BaseIdEntity::getId)).list();
        respVo.setUnitReqVos(CrmBeanUtil.copyList((List)productUnitEntities, KmsProductUnitRespVo.class));
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsTenantryDirectProductReqVo reqVo) {
        this.check(reqVo);
        this.checkDataExist(reqVo);
        KmsTenantryDirectProductEntity entity = (KmsTenantryDirectProductEntity)CrmBeanUtil.copy((Object)reqVo, KmsTenantryDirectProductEntity.class);
        this.save(entity);
        List unitEntities = CrmBeanUtil.copyList((List)reqVo.getUnitReqVos(), KmsProductUnitEntity.class);
        unitEntities.forEach(o -> o.setTenantryDirectProductId(entity.getId()));
        this.kmsProductUnitService.saveBatch(unitEntities);
        KmsTenantryDirectProductRespVo newData = (KmsTenantryDirectProductRespVo)CrmBeanUtil.copy((Object)entity, KmsTenantryDirectProductRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        newData.setUnitReqVos(CrmBeanUtil.copyList((List)unitEntities, KmsProductUnitRespVo.class));
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    private void checkDataExist(KmsTenantryDirectProductReqVo reqVo) {
        Set integerSet;
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectProductEntity> entities = this.kmsTenantryDirectProductMapper.selectListForSave(reqVo);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        if (reqVo.getTimeOfWeek() == null) {
            throw new BusinessException("\u8be5\u5546\u54c1\u5df2\u7ecf\u5b58\u5728");
        }
        if (reqVo.getTimeOfWeek() != null && (integerSet = entities.stream().map(KmsTenantryDirectProductEntity::getTimeOfWeek).collect(Collectors.toSet())).contains(reqVo.getTimeOfWeek())) {
            throw new BusinessException("\u8be5\u661f\u671f\u6570\u7684\u5546\u54c1\u5df2\u5b58\u5728");
        }
    }

    protected void check(KmsTenantryDirectProductReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getProductCode(), (String)"\u4f01\u4e1a\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getProductName(), (String)"\u4f01\u4e1a\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getKaProductCode(), (String)"\u5546\u8d85\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIsDefault(), (String)"\u662f\u5426\u9ed8\u8ba4\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSellPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String isDefault = reqVo.getIsDefault();
        if (StringUtils.isNotEmpty((String)isDefault) && !YesNoEnum.yesNoEnum.YES.getValue().equals(isDefault) && !YesNoEnum.yesNoEnum.NO.getValue().equals(isDefault)) {
            throw new BusinessException("\u662f\u5426\u9ed8\u8ba4\u5546\u54c1\u6570\u636e\u9519\u8bef(Y/N)");
        }
        String isDirect = reqVo.getIsDirect();
        if (StringUtils.isNotEmpty((String)isDirect) && !YesNoEnum.yesNoEnum.YES.getValue().equals(isDirect) && !YesNoEnum.yesNoEnum.NO.getValue().equals(isDirect)) {
            throw new BusinessException("\u662f\u5426\u76f4\u8425\u5546\u54c1\u6570\u636e\u9519\u8bef(Y/N)");
        }
        List unitReqVos = reqVo.getUnitReqVos();
        AssertUtils.isNotEmpty((Collection)unitReqVos, (String)"\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        unitReqVos.forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getUnitCode(), (String)"\u4f01\u4e1a\u4ea7\u54c1\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getUnitName(), (String)"\u4f01\u4e1a\u4ea7\u54c1\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getKaUnitCode(), (String)"\u5546\u8d85\u4ea7\u54c1\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getOrderType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            String orderTypeStr = (String)KmsAdminEnum.OrderType.GETMAP.get(o.getOrderType());
            AssertUtils.isNotEmpty((String)orderTypeStr, (String)"\u5355\u636e\u7c7b\u578b\u9519\u8bef");
            AssertUtils.isNotNull((Object)o.getRatio(), (String)"\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb\u5546\u8d85\u5355\u4f4d\u6570\u91cf[ratio]\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)o.getNumerator(), (String)"\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb\u4f01\u4e1a\u5355\u4f4d\u6570\u91cf[numerator]\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsTenantryDirectProductReqVo reqVo) {
        this.check(reqVo);
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u66f4\u65b0\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsTenantryDirectProductEntity entity = (KmsTenantryDirectProductEntity)this.getById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)entity, (String)"\u672a\u67e5\u8be2\u5230\u5f85\u66f4\u65b0\u6570\u636e\u4fe1\u606f");
        this.checkDataExist(reqVo);
        BeanUtils.copyProperties((Object)reqVo, (Object)entity);
        KmsTenantryDirectProductRespVo oldData = this.query(reqVo);
        this.updateById(entity);
        ((LambdaUpdateChainWrapper)this.kmsProductUnitService.lambdaUpdate().eq(KmsProductUnitEntity::getTenantryDirectProductId, (Object)entity.getId())).remove();
        List unitEntities = CrmBeanUtil.copyList((List)reqVo.getUnitReqVos(), KmsProductUnitEntity.class);
        unitEntities.forEach(o -> o.setTenantryDirectProductId(entity.getId()));
        this.kmsProductUnitService.saveBatch(unitEntities);
        KmsTenantryDirectProductRespVo newData = this.query(reqVo);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsTenantryDirectProductReqVo reqVo) {
        List kmsTenantryDirectProductEntities = this.kmsTenantryDirectProductMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectProductEntities)) {
            kmsTenantryDirectProductEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsTenantryDirectProductReqVo reqVo) {
        List kmsTenantryDirectProductEntities = this.kmsTenantryDirectProductMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectProductEntities)) {
            kmsTenantryDirectProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsTenantryDirectProductReqVo reqVo) {
        List kmsTenantryDirectProductEntities = this.kmsTenantryDirectProductMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectProductEntities)) {
            kmsTenantryDirectProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectProductEntities);
    }

    @Override
    public PageResult<KmsProductForExportRespVo> listForExport(KmsTenantryDirectProductReqVo reqVo) {
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsProductForExportRespVo> list = this.kmsTenantryDirectProductMapper.findListForExport((Page<KmsProductForExportRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

