/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderFormReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormExportRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.orderform.service.IKmsOrderFormService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsorderform"})
@Api(tags={"\u5546\u8d85\u5355\u636e-\u8ba2\u8d27\u5355"})
public class KmsOrderFormController {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderFormController.class);
    @Autowired
    private IKmsOrderFormService kmsOrderFormService;
    @Resource
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsOrderFormRespVo>> list(@RequestBody KmsOrderFormReqVo kmsOrderFormReqVo) {
        PageResult<KmsOrderFormRespVo> result = this.kmsOrderFormService.findList(kmsOrderFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\u5bfc\u51fa")
    @PostMapping(value={"/listForExport"})
    @CrmLog
    public Result<PageResult<KmsOrderFormExportRespVo>> listForExcel(@RequestBody KmsOrderFormReqVo reqVo) {
        PageResult<KmsOrderFormExportRespVo> result = this.kmsOrderFormService.listFprExport(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsOrderFormRespVo> query(@RequestBody KmsOrderFormReqVo kmsOrderFormReqVo) {
        KmsOrderFormRespVo respVo = this.kmsOrderFormService.query(kmsOrderFormReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsOrderFormReqVo kmsOrderFormReqVo) {
        this.kmsOrderFormService.save(kmsOrderFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsOrderFormReqVo kmsOrderFormReqVo) {
        this.kmsOrderFormService.update(kmsOrderFormReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.kmsOrderFormService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody KmsOrderFormReqVo kmsOrderFormReqVo) {
        this.kmsOrderFormService.enableBatch(kmsOrderFormReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody KmsOrderFormReqVo kmsOrderFormReqVo) {
        this.kmsOrderFormService.disableBatch(kmsOrderFormReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u52a0\u6025\u8ba2\u5355")
    @PostMapping(value={"/expedited"})
    @CrmLog
    public Result expedited(@RequestBody List<String> ids) {
        KmsOrderFormReqVo kmsOrderFormReqVo = new KmsOrderFormReqVo();
        kmsOrderFormReqVo.setIds(ids);
        this.kmsOrderFormService.expedited(kmsOrderFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u53d6\u6d88\u52a0\u6025")
    @PostMapping(value={"/cancelExpedited"})
    @CrmLog
    public Result cancelExpedited(@RequestBody List<String> ids) {
        KmsOrderFormReqVo kmsOrderFormReqVo = new KmsOrderFormReqVo();
        kmsOrderFormReqVo.setIds(ids);
        this.kmsOrderFormService.cancelExpedited(kmsOrderFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362\u8ba2\u8d27\u5355")
    @PostMapping(value={"/manualTrans"})
    @CrmLog
    public Result manualTrans(@RequestBody List<String> ids) {
        block7: {
            RLock rLock = null;
            try {
                rLock = this.redissonUtil.createLock("MANUAL_TRANS_FORM");
                if (this.redissonUtil.tryLock(rLock, 0L, 3600L)) {
                    KmsOrderFormReqVo kmsOrderFormReqVo = new KmsOrderFormReqVo();
                    kmsOrderFormReqVo.setIds(ids);
                    this.kmsOrderFormService.manualTrans(kmsOrderFormReqVo);
                    break block7;
                }
                throw new BusinessException("\u6709\u4eba\u6b63\u5728\u8fdb\u884c\u5355\u636e\u8f6c\u6362\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            catch (BusinessException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            }
            finally {
                this.redissonUtil.unLock(rLock);
            }
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5355\u636e\u63a8\u9001\u67e5\u8be2\u5355\u636e\u4fe1\u606f")
    @PostMapping(value={"/findPushList"})
    @CrmLog
    public Result<List<KmsOrderFormRespVo>> findPushList(@RequestBody List<String> ids) {
        KmsOrderFormReqVo kmsOrderFormReqVo = new KmsOrderFormReqVo();
        kmsOrderFormReqVo.setIds(ids);
        List<KmsOrderFormRespVo> respVos = this.kmsOrderFormService.pushList(kmsOrderFormReqVo);
        return Result.ok(respVos);
    }

    @ApiOperation(value="\u5355\u636e\u63a8\u9001")
    @PostMapping(value={"/push"})
    @CrmLog
    public Result push(@RequestBody KmsOrderFormReqVo params) {
        block7: {
            RLock rLock = null;
            try {
                rLock = this.redissonUtil.createLock("PUSH_ORDER_FORM_TO_SAP");
                if (this.redissonUtil.tryLock(rLock, 0L, 3600L)) {
                    AssertUtils.isNotEmpty((Collection)params.getIds(), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u63a8\u9001\u7684\u5355\u636e\u4fe1\u606f");
                    List kmsOrderFormEntities = this.kmsOrderFormService.listByIds(params.getIds());
                    kmsOrderFormEntities.forEach(o -> {
                        if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                            throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
                        }
                    });
                    params.getIds().forEach(o -> {
                        params.setId(o);
                        this.kmsOrderFormService.push(params);
                    });
                    break block7;
                }
                throw new BusinessException("\u6709\u4eba\u6b63\u5728\u63a8\u9001\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            catch (BusinessException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            }
            finally {
                this.redissonUtil.unLock(rLock);
            }
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

