/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.returnform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnFormReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormExportRespVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormRespVo;
import com.biz.crm.returnform.service.IKmsReturnFormService;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsreturnform"})
@Api(tags={"\u5546\u8d85\u5355\u636e-\u9000\u8d27\u5355"})
public class KmsReturnFormController {
    private static final Logger log = LoggerFactory.getLogger(KmsReturnFormController.class);
    @Autowired
    private IKmsReturnFormService kmsReturnFormService;
    @Resource
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsReturnFormRespVo>> list(@RequestBody KmsReturnFormReqVo kmsReturnFormReqVo) {
        PageResult<KmsReturnFormRespVo> result = this.kmsReturnFormService.findList(kmsReturnFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\u5bfc\u51fa")
    @PostMapping(value={"/listForExport"})
    @CrmLog
    public Result<PageResult<KmsReturnFormExportRespVo>> listForExport(@RequestBody KmsReturnFormReqVo reqVo) {
        PageResult<KmsReturnFormExportRespVo> result = this.kmsReturnFormService.listForExport(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsReturnFormRespVo> query(@RequestBody KmsReturnFormReqVo kmsReturnFormReqVo) {
        KmsReturnFormRespVo respVo = this.kmsReturnFormService.query(kmsReturnFormReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsReturnFormReqVo kmsReturnFormReqVo) {
        this.kmsReturnFormService.save(kmsReturnFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsReturnFormReqVo kmsReturnFormReqVo) {
        this.kmsReturnFormService.update(kmsReturnFormReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.kmsReturnFormService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody KmsReturnFormReqVo kmsReturnFormReqVo) {
        this.kmsReturnFormService.enableBatch(kmsReturnFormReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody KmsReturnFormReqVo kmsReturnFormReqVo) {
        this.kmsReturnFormService.disableBatch(kmsReturnFormReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u624b\u52a8\u8f6c\u9000\u8d27\u5355")
    @PostMapping(value={"/manualTrans"})
    @CrmLog
    public Result manualTrans(@RequestBody List<String> ids) {
        block7: {
            RLock rLock = null;
            try {
                rLock = this.redissonUtil.createLock("MANUAL_TRANS_FORM");
                if (this.redissonUtil.tryLock(rLock, 0L, 3600L)) {
                    KmsReturnFormReqVo kmsReturnFormReqVo = new KmsReturnFormReqVo();
                    kmsReturnFormReqVo.setIds(ids);
                    this.kmsReturnFormService.manualTrans(kmsReturnFormReqVo);
                    break block7;
                }
                throw new BusinessException("\u6709\u4eba\u6b63\u5728\u8fdb\u884c\u5355\u636e\u8f6c\u6362\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            catch (BusinessException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            }
            finally {
                this.redissonUtil.unLock(rLock);
            }
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

