/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.returnform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnFormReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormExportRespVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnFormRespVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnGoodsRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.rawdata.mapper.KmsReturnFormDetailDwMapper;
import com.biz.crm.rawdata.model.KmsReturnFormDetailDwEntity;
import com.biz.crm.returnform.helper.KmsReturnFormHelper;
import com.biz.crm.returnform.mapper.KmsReturnFormMapper;
import com.biz.crm.returnform.mapper.KmsReturnGoodsMapper;
import com.biz.crm.returnform.model.KmsReturnFormEntity;
import com.biz.crm.returnform.model.KmsReturnGoodsEntity;
import com.biz.crm.returnform.service.IKmsReturnFormService;
import com.biz.crm.returnform.service.IKmsReturnGoodsService;
import com.biz.crm.returnform.service.IKmsReturnStatusRecordService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.soap.SOAPException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsReturnFormServiceExpandImpl"})
public class KmsReturnFormServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsReturnFormMapper, KmsReturnFormEntity>
implements IKmsReturnFormService {
    private static final Logger log = LoggerFactory.getLogger(KmsReturnFormServiceImpl.class);
    @Resource
    private KmsReturnFormMapper kmsReturnFormMapper;
    @Resource
    private KmsReturnGoodsMapper kmsReturnGoodsMapper;
    @Resource
    private KmsReturnFormHelper kmsReturnFormHelper;
    @Resource
    private IKmsReturnGoodsService kmsReturnGoodsService;
    @Resource
    private IKmsReturnStatusRecordService kmsReturnStatusRecordService;
    @Resource
    private KmsReturnFormDetailDwMapper returnFormDetailDwMapper;

    @Override
    public PageResult<KmsReturnFormRespVo> findList(KmsReturnFormReqVo reqVo) {
        Page page;
        List<KmsReturnFormRespVo> list;
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(list = this.kmsReturnFormMapper.findList((Page<KmsReturnFormRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> {
                if (StringUtils.isEmpty((String)o.getFinalReturnAmount())) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(KmsReturnGoodsEntity::getVersionNumber, (Object)o.getVersionNumber());
                    wrapper.eq(KmsReturnGoodsEntity::getOrderNumber, (Object)o.getOrderNumber());
                    List kmsReturnGoodsEntities = this.kmsReturnGoodsMapper.selectList((Wrapper)wrapper);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)kmsReturnGoodsEntities)) {
                        List kmsReturnGoodsRespVos = CrmBeanUtil.copyList((List)kmsReturnGoodsEntities, KmsReturnGoodsRespVo.class);
                        BigDecimal returnAmount = new BigDecimal(0);
                        for (KmsReturnGoodsRespVo goodsRespVo : kmsReturnGoodsRespVos) {
                            if (!StringUtils.isNotEmpty((String)goodsRespVo.getReturnAmount())) continue;
                            returnAmount = returnAmount.add(new BigDecimal(goodsRespVo.getReturnAmount().replaceAll("-", "")));
                        }
                        o.setFinalReturnAmount(returnAmount.toString());
                    }
                }
                o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsReturnFormRespVo query(KmsReturnFormReqVo reqVo) {
        String id = reqVo.getId();
        AssertUtils.isNotEmpty((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsReturnFormEntity returnFormEntity = (KmsReturnFormEntity)this.kmsReturnFormMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)returnFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        KmsReturnFormRespVo formRespVo = (KmsReturnFormRespVo)CrmBeanUtil.copy((Object)returnFormEntity, KmsReturnFormRespVo.class);
        String orderNumber = formRespVo.getOrderNumber();
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsReturnGoodsEntity::getOrderNumber, (Object)orderNumber);
        List goodsEntities = this.kmsReturnGoodsMapper.selectList((Wrapper)build);
        goodsEntities.forEach(goodsEntity -> {
            if (StringUtils.isNotEmpty((String)goodsEntity.getReturnAmount())) {
                goodsEntity.setReturnAmount(goodsEntity.getReturnAmount().replaceAll("-", ""));
            }
        });
        formRespVo.setReturnGoodsVos(CrmBeanUtil.copyList((List)goodsEntities, KmsReturnGoodsRespVo.class));
        return formRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsReturnFormReqVo reqVo) {
        KmsReturnFormEntity entity = (KmsReturnFormEntity)CrmBeanUtil.copy((Object)reqVo, KmsReturnFormEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsReturnFormReqVo reqVo) {
        KmsReturnFormEntity entity = (KmsReturnFormEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c!");
        }
        List kmsReturnFormEntities = this.kmsReturnFormMapper.selectBatchIds(ids);
        if (CollectionUtil.listEmpty((List)kmsReturnFormEntities)) {
            throw new BusinessException("\u672a\u627e\u5230\u5220\u9664\u6570\u636e!");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(BaseIdEntity::getId, ids);
        this.kmsReturnFormMapper.delete((Wrapper)wrapper);
        ArrayList orderList = Lists.newArrayList();
        List kmsReturnFormRespVos = CrmBeanUtil.copyList((List)kmsReturnFormEntities, KmsReturnFormRespVo.class);
        for (KmsReturnFormRespVo vo : kmsReturnFormRespVos) {
            orderList.add(vo.getOrderNumber());
        }
        LambdaUpdateWrapper dwWrapper = new LambdaUpdateWrapper();
        dwWrapper.in(KmsReturnFormDetailDwEntity::getOrderNumber, (Collection)orderList);
        this.returnFormDetailDwMapper.delete((Wrapper)dwWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsReturnFormReqVo reqVo) {
        List kmsReturnFormEntities = this.kmsReturnFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsReturnFormEntities)) {
            kmsReturnFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsReturnFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsReturnFormReqVo reqVo) {
        List kmsReturnFormEntities = this.kmsReturnFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsReturnFormEntities)) {
            kmsReturnFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsReturnFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrans(KmsReturnFormReqVo kmsReturnFormReqVo) {
        List ids = kmsReturnFormReqVo.getIds();
        AssertUtils.isNotEmpty((Collection)ids, (String)"\u8bf7\u9009\u62e9\u5f85\u8f6c\u6362\u6570\u636e");
        if (ids.size() > 100) {
            throw new BusinessException("\u6700\u591a\u53ea\u80fd\u5904\u7406100\u6761\u6570\u636e\uff01");
        }
        List returnFormEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        List dwRespVos = CrmBeanUtil.copyList((List)returnFormEntities, KmsReturnFormDetailDwRespVo.class);
        dwRespVos.forEach(dwRespVo -> {
            KmsReturnFormEntity returnFormEntity = this.kmsReturnFormHelper.transFormVersion((KmsReturnFormDetailDwRespVo)dwRespVo);
            List<KmsReturnGoodsEntity> goodsEntities = this.kmsReturnFormHelper.transGoodsVersion(returnFormEntity);
            this.kmsReturnFormHelper.transData(returnFormEntity, goodsEntities);
            this.saveOrUpdate(returnFormEntity);
            this.kmsReturnGoodsService.saveOrUpdateBatch(goodsEntities);
            this.kmsReturnStatusRecordService.insert(returnFormEntity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoTransData(KmsReturnFormDetailDwRespVo dwRespVo) {
        KmsReturnFormEntity returnFormEntity = this.kmsReturnFormHelper.transFormVersion(dwRespVo);
        List<KmsReturnGoodsEntity> goodsEntities = this.kmsReturnFormHelper.transGoodsVersion(returnFormEntity);
        this.kmsReturnFormHelper.transData(returnFormEntity, goodsEntities);
        this.saveOrUpdate(returnFormEntity);
        this.kmsReturnGoodsService.saveOrUpdateBatch(goodsEntities);
        this.kmsReturnStatusRecordService.insert(returnFormEntity);
    }

    @Override
    public PageResult<KmsReturnFormExportRespVo> listForExport(KmsReturnFormReqVo reqVo) {
        Page page;
        List<KmsReturnFormExportRespVo> list;
        AssertUtils.isNotEmpty((String)reqVo.getOrderDateStart(), (String)"\u8ba2\u5355\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrderDateEnd(), (String)"\u8ba2\u5355\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(list = this.kmsReturnFormMapper.findListForExport((Page<KmsReturnFormExportRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> {
                if (StringUtils.isEmpty((String)o.getFinalReturnAmount())) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(KmsReturnGoodsEntity::getVersionNumber, (Object)o.getVersionNumber());
                    wrapper.eq(KmsReturnGoodsEntity::getOrderNumber, (Object)o.getOrderNumber());
                    List kmsReturnGoodsEntities = this.kmsReturnGoodsMapper.selectList((Wrapper)wrapper);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)kmsReturnGoodsEntities)) {
                        List kmsReturnGoodsRespVos = CrmBeanUtil.copyList((List)kmsReturnGoodsEntities, KmsReturnGoodsRespVo.class);
                        BigDecimal returnAmount = new BigDecimal(0);
                        for (KmsReturnGoodsRespVo goodsRespVo : kmsReturnGoodsRespVos) {
                            if (!StringUtils.isNotEmpty((String)goodsRespVo.getReturnAmount())) continue;
                            returnAmount = returnAmount.add(new BigDecimal(goodsRespVo.getReturnAmount().replaceAll("-", "")));
                        }
                        o.setFinalReturnAmount(returnAmount.toString());
                    }
                }
                o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

