/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salesdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.salesdata.req.KmsSalesDataReqVo;
import com.biz.crm.nebular.kms.salesdata.resp.KmsSalesDataRespVo;
import com.biz.crm.salesdata.helper.KmsSalesDataHelper;
import com.biz.crm.salesdata.mapper.KmsSalesDataMapper;
import com.biz.crm.salesdata.model.KmsSalesDataEntity;
import com.biz.crm.salesdata.service.IKmsSalesDataService;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.trans.helper.KmsTransDataHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsSalesDataServiceExpandImpl"})
public class KmsSalesDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsSalesDataMapper, KmsSalesDataEntity>
implements IKmsSalesDataService {
    private static final Logger log = LoggerFactory.getLogger(KmsSalesDataServiceImpl.class);
    @Resource
    private KmsSalesDataMapper kmsSalesDataMapper;
    @Resource
    private KmsSalesDataHelper kmsSalesDataHelper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private KmsTransDataHelper kmsTransDataHelper;
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Override
    public PageResult<KmsSalesDataRespVo> findList(KmsSalesDataReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsSalesDataRespVo> list = this.kmsSalesDataMapper.findList((Page<KmsSalesDataRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsSalesDataRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        KmsSalesDataEntity entity = (KmsSalesDataEntity)this.kmsSalesDataMapper.selectById((Serializable)((Object)id));
        KmsSalesDataRespVo respVo = (KmsSalesDataRespVo)CrmBeanUtil.copy((Object)entity, KmsSalesDataRespVo.class);
        KmsTenantryDirectCustomerOrgEntity bs = (KmsTenantryDirectCustomerOrgEntity)this.kmsTenantryDirectCustomerOrgMapper.selectById((Serializable)((Object)respVo.getBsDirectSystemId()));
        if (bs != null) {
            respVo.setKaCode(bs.getBsDirectSystemCode());
            respVo.setKaName(bs.getBsDirectSystemName());
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsSalesDataReqVo reqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsSalesDataReqVo reqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsSalesDataReqVo reqVo) {
        List kmsSalesDataEntities = this.kmsSalesDataMapper.selectBatchIds(reqVo.getIds());
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        String menuObjectStr = (String)menuObject;
        if (CollectionUtils.isNotEmpty((Collection)kmsSalesDataEntities)) {
            kmsSalesDataEntities.forEach(o -> {
                KmsSalesDataEntity oldEntity = (KmsSalesDataEntity)CrmBeanUtil.copy((Object)o, KmsSalesDataEntity.class);
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                if (menuObject != null) {
                    this.crmLogSendUtil.sendForUpdate(menuObjectStr, o.getId(), o.getOrderNumber(), (Object)oldEntity, o);
                }
            });
        }
        this.updateBatchById(kmsSalesDataEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsSalesDataReqVo reqVo) {
        List kmsSalesDataEntities = this.kmsSalesDataMapper.selectBatchIds(reqVo.getIds());
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        String menuObjectStr = (String)menuObject;
        if (CollectionUtils.isNotEmpty((Collection)kmsSalesDataEntities)) {
            kmsSalesDataEntities.forEach(o -> {
                KmsSalesDataEntity oldEntity = (KmsSalesDataEntity)CrmBeanUtil.copy((Object)o, KmsSalesDataEntity.class);
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                if (menuObject != null) {
                    this.crmLogSendUtil.sendForUpdate(menuObjectStr, o.getId(), o.getOrderNumber(), (Object)oldEntity, o);
                }
            });
        }
        this.updateBatchById(kmsSalesDataEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoTransData(KmsSaleDataFormDetailDwRespVo dwRespVo) {
        KmsSalesDataEntity salesDataEntity = this.kmsSalesDataHelper.transFormVersion(dwRespVo);
        if (!ObjectUtils.isEmpty((Object)salesDataEntity)) {
            this.kmsSalesDataHelper.transData(salesDataEntity);
            this.saveOrUpdate(salesDataEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrans(KmsSalesDataReqVo kmsSalesDataReqVo) {
        List ids = kmsSalesDataReqVo.getIds();
        AssertUtils.isNotEmpty((Collection)ids, (String)"\u8bf7\u9009\u62e9\u5f85\u8f6c\u6362\u6570\u636e");
        List kmsSalesDataEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        List detailDwRespVos = CrmBeanUtil.copyList((List)kmsSalesDataEntities, KmsSaleDataFormDetailDwRespVo.class);
        detailDwRespVos.forEach(dwRespVo -> {
            KmsSalesDataEntity kmsSalesDataEntity = this.kmsSalesDataHelper.transFormVersion((KmsSaleDataFormDetailDwRespVo)dwRespVo);
            if (!ObjectUtils.isEmpty((Object)kmsSalesDataEntity)) {
                this.kmsSalesDataHelper.transData(kmsSalesDataEntity);
                this.saveOrUpdate(kmsSalesDataEntity);
            }
        });
    }
}

