/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sap.helper;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.KmsSapConfig;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.orderform.helper.KmsOrderFormHelper;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import com.biz.crm.util.ComConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.HttpClientUtils;
import com.biz.crm.util.JDBCUtils;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.XmlBeanUtil;
import com.biz.crm.webservice.order.req.KmsOrderFormPushSapReqVo;
import com.biz.crm.webservice.order.resp.KmsOrderFormPushSapRespVo;
import com.biz.crm.webservice.order.resp.KmsSapRespMessageItem;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsSapHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsSapHelper.class);
    @Resource
    private KmsSapConfig kmsSapConfig;
    @Resource
    private KmsOrderFormHelper kmsOrderFormHelper;

    public void push(KmsOrderFormEntity orderFormEntity, List<KmsOrderGoodsEntity> goodsEntities, Integer timeOfDay) {
        try {
            KmsOrderFormRespVo orderFormRespVo = (KmsOrderFormRespVo)CrmBeanUtil.copy((Object)orderFormEntity, KmsOrderFormRespVo.class);
            List orderGoodsRespVos = CrmBeanUtil.copyList(goodsEntities, KmsOrderGoodsRespVo.class);
            List goodsSortedRespVos = orderGoodsRespVos.stream().sorted(Comparator.comparing(KmsOrderGoodsRespVo::getItemIndex)).collect(Collectors.toList());
            orderFormRespVo.setGoodsVos(goodsSortedRespVos);
            orderFormRespVo.setTimeOfDay(timeOfDay);
            KmsOrderFormPushSapReqVo compensationReqVo = KmsOrderFormPushSapReqVo.builder().kmsOrderFormRespVo(orderFormRespVo).build();
            Map goodsEntityMap = goodsEntities.stream().filter(o -> !StringUtils.isEmpty((Object)o.getGoodsCode())).collect(Collectors.toMap(o -> o.getGoodsCode(), Function.identity(), (v1, v2) -> {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u5546\u54c1\u6570\u636e\u4fe1\u606f");
            }));
            if (CollectionUtils.isEmpty(goodsEntityMap)) {
                throw new BusinessException("\u6ca1\u6709\u8f6c\u6362\u6210\u529f\u7684\u5546\u54c1\u4fe1\u606f");
            }
            AtomicInteger i = new AtomicInteger(1);
            compensationReqVo.getBody().getKmsZsdSalesorderDataRfcVo().getItmeVo().getItmeDataVos().forEach(o -> {
                String itemNo = String.valueOf(i.get() * 10);
                o.setPosex(itemNo);
                i.getAndIncrement();
            });
            String body = XmlBeanUtil.beanToXml((Object)compensationReqVo, (String)StandardCharsets.UTF_8.name());
            Result result = HttpClientUtils.doPostWebService((String)this.kmsSapConfig.getSendSapAddr(), (String)this.kmsSapConfig.getSendSapUserName(), (String)this.kmsSapConfig.getSendSapPassWord(), (String)body);
            if (ComConstant.SC_OK_200.equals(result.getCode())) {
                KmsOrderFormPushSapRespVo respVo = (KmsOrderFormPushSapRespVo)XmlBeanUtil.xmlToBean((String)((String)result.getResult()), KmsOrderFormPushSapRespVo.class);
                String etVbeln = respVo.getBody().getKmsZsdSalesorderDataRfcRespVo().getEtVbeln();
                if (!StringUtils.isEmpty((Object)etVbeln)) {
                    List<KmsSapRespMessageItem> item = respVo.getBody().getKmsZsdSalesorderDataRfcRespVo().getEtBapireturn1().getItem();
                    if (CollectionUtils.isEmpty(item)) {
                        orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S500.getValue());
                        orderFormEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S500.getDescription());
                        orderFormEntity.setSapNumber(etVbeln);
                        orderFormEntity.setIsTrans(YesNoEnum.yesNoEnum.no.getValue());
                        compensationReqVo.getBody().getKmsZsdSalesorderDataRfcVo().getItmeVo().getItmeDataVos().forEach(o -> {
                            String key = o.getMatnr();
                            KmsOrderGoodsEntity goodsEntity = (KmsOrderGoodsEntity)goodsEntityMap.get(key);
                            if (!ObjectUtils.isEmpty((Object)goodsEntity)) {
                                goodsEntity.setSapItemNo(o.getPosex());
                            }
                        });
                    } else {
                        orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S500.getValue());
                        StringBuilder sb = new StringBuilder("");
                        item.forEach(o -> sb.append(o.getMessageMsgV4() + "|"));
                        orderFormEntity.setOrderStatusMsg(sb.toString());
                    }
                } else {
                    List<KmsSapRespMessageItem> item = respVo.getBody().getKmsZsdSalesorderDataRfcRespVo().getEtBapireturn1().getItem();
                    StringBuilder sb = new StringBuilder("");
                    item.forEach(o -> sb.append(o.getMessageMsgV4() + "|"));
                    orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S501.getValue());
                    orderFormEntity.setOrderStatusMsg(sb.toString());
                }
            } else {
                orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S501.getValue());
                orderFormEntity.setOrderStatusMsg(result.getMessage());
            }
        }
        catch (BusinessException e) {
            log.info("\u5355\u636e\u63a8\u9001SAP\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S501.getValue());
            orderFormEntity.setOrderStatusMsg(e.getMessage());
        }
        catch (Exception e) {
            log.info("\u5355\u636e\u63a8\u9001SAP\u5f02\u5e38\uff1a{}", (Object)KmsUtils.errorString(e.getStackTrace(), null));
            orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S501.getValue());
            orderFormEntity.setOrderStatusMsg("\u8ba2\u5355\u63a8\u9001\u5f02\u5e38\uff01");
        }
    }

    public Integer getHanaInvoiceCount(KmsSapOrderFormReqVo reqVo) {
        Integer count = 0;
        Connection con = JDBCUtils.getConnection();
        Statement sta = null;
        ResultSet resultSet = null;
        try {
            sta = con.createStatement();
            String whereStr = this.buildWhereStr(reqVo);
            String sql = "SELECT COUNT(*) FROM ECCPRD.ZFSSC_VBRK_VBRP_KMS t WHERE " + whereStr;
            log.info("SAP\u6293\u53d6SQL\uff1a{}", (Object)sql);
            resultSet = sta.executeQuery(sql);
            while (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                log.info("\u62c9\u53d6SAP\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
                throw new BusinessException(e.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResource(con, sta, resultSet);
                throw throwable;
            }
        }
        JDBCUtils.closeResource(con, sta, resultSet);
        return count;
    }

    protected String buildWhereStr(KmsSapOrderFormReqVo reqVo) {
        String whereStr = "t.FKART IN (" + reqVo.getInvoiceTypeList().stream().collect(Collectors.joining(",")) + ")";
        if (!CollectionUtils.isEmpty((Collection)reqVo.getCompanyCodeList())) {
            whereStr = whereStr + " AND t.BUKRS IN (" + reqVo.getCompanyCodeList().stream().collect(Collectors.joining(",")) + ")";
        } else if (!StringUtils.isEmpty((Object)reqVo.getCompanyCode())) {
            whereStr = whereStr + " AND t.BUKRS IN ('" + reqVo.getCompanyCode() + "')";
        }
        if (!CollectionUtils.isEmpty((Collection)reqVo.getStoreCodeList())) {
            whereStr = whereStr + " AND t.KUNNR IN (" + reqVo.getStoreCodeList().stream().collect(Collectors.joining(",")) + ")";
        }
        if (!CollectionUtils.isEmpty((Collection)reqVo.getSoldToPartyCodeList())) {
            whereStr = whereStr + " AND t.KUNAG IN (" + reqVo.getSoldToPartyCodeList().stream().collect(Collectors.joining(",")) + ")";
        }
        whereStr = StringUtils.isEmpty((Object)reqVo.getInvoiceCreateTime()) ? whereStr + " AND t.FKDAT = '" + reqVo.getStartTime().replaceAll("-", "") + "' AND t.FKIMG = t.FKIMGZP" : whereStr + " AND t.ERZET LIKE '" + reqVo.getInvoiceCreateTime().replaceAll("-", "") + "%' AND t.FKIMG = t.FKIMGZP";
        return whereStr;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<KmsSapInvoiceEntity> pullHanaInvoice(KmsSapOrderFormReqVo reqVo) {
        Connection con = JDBCUtils.getConnection();
        Statement sta = null;
        ResultSet resultSet = null;
        ArrayList invoiceEntities = Lists.newArrayList();
        try {
            int offset = reqVo.getPageSize() * reqVo.getPageNum();
            sta = con.createStatement();
            String whereStr = this.buildWhereStr(reqVo);
            String sql = "SELECT t.fkdat,t.erzet,t.fkart,t.fkartvtext,t.vbeln,t.posnr,t.pstyv,t.vtext,t.vgbel,t.vgpos,t.aubel,t.aupos,t.bukrs,t.matnr,t.maktx,t.mtpos,t.fkimg,t.fkimgzp,t.vrkme,t.vrkmename,t.fkimg1,t.fkimgzp1,t.kmein,t.kmeinname,t.netwr,t.mwsbp,t.kzwi1,t.mwsi1,t.kzwi4,t.yk99,t.kunnr,t.kunnrname,t.kunag,t.kunagname,t.vrkmetype,t.guige,t.vtweg,t.vbakerdat,t.lifnr,t.name3,t.bstkd,t.danjia,t.yk04,t.yk11,t.zst2,t.pernr,t.name4 FROM ECCPRD.ZFSSC_VBRK_VBRP_KMS t WHERE " + whereStr;
            log.info("\u6293\u53d6SAP\u6570\u636eSQL\uff1a{}", (Object)sql);
            resultSet = sta.executeQuery(sql);
            ResultSetMetaData meta = resultSet.getMetaData();
            int cols = meta.getColumnCount();
            while (resultSet.next()) {
                Class<KmsSapInvoiceEntity> clazz = KmsSapInvoiceEntity.class;
                Object obj = KmsSapInvoiceEntity.class.newInstance();
                for (int i = 1; i <= cols; ++i) {
                    Field field = null;
                    field = clazz.getDeclaredField(meta.getColumnName(i).toLowerCase());
                    field.setAccessible(true);
                    field.set(obj, resultSet.getObject(i));
                }
                KmsSapInvoiceEntity entity = (KmsSapInvoiceEntity)obj;
                entity.setId(entity.getVbeln() + entity.getPosnr());
                invoiceEntities.add(entity);
            }
        }
        catch (IllegalAccessException e) {
            try {
                log.info("\u62c9\u53d6SAP\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
                throw new BusinessException(e.getMessage());
                catch (InstantiationException e2) {
                    log.info("\u62c9\u53d6SAP\u6570\u636e\u5931\u8d25:{}", (Object)e2.getMessage());
                    throw new BusinessException(e2.getMessage());
                }
                catch (SQLException e3) {
                    log.info("\u62c9\u53d6SAP\u6570\u636e\u5931\u8d25:{}", (Object)e3.getMessage());
                    throw new BusinessException(e3.getMessage());
                }
                catch (NoSuchFieldException e4) {
                    log.info("\u62c9\u53d6SAP\u6570\u636e\u5931\u8d25:{}", (Object)e4.getMessage());
                    throw new BusinessException(e4.getMessage());
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResource(con, sta, resultSet);
                throw throwable;
            }
        }
        JDBCUtils.closeResource(con, sta, resultSet);
        return invoiceEntities;
    }
}

