/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sap.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.finance.helper.KmsAuditTemplateHelper;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.helper.KmsSapHelper;
import com.biz.crm.sap.mapper.KmsSapOrderFormMapper;
import com.biz.crm.sap.model.KmsSapOrderFormEntity;
import com.biz.crm.sap.service.IKmsSapInvoiceService;
import com.biz.crm.sap.service.IKmsSapOrderFormService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsSapOrderFormServiceExpandImpl"})
public class KmsSapOrderFormServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsSapOrderFormMapper, KmsSapOrderFormEntity>
implements IKmsSapOrderFormService {
    private static final Logger log = LoggerFactory.getLogger(KmsSapOrderFormServiceImpl.class);
    @Resource
    private KmsSapOrderFormMapper kmsSapOrderFormMapper;
    @Resource
    private KmsSapHelper kmsSapHelper;
    @Resource
    private IKmsSapInvoiceService kmsSapInvoiceService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private KmsAuditTemplateHelper kmsAuditTemplateHelper;

    @Override
    public PageResult<KmsSapOrderFormRespVo> findList(KmsSapOrderFormReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsSapOrderFormRespVo> list = this.kmsSapOrderFormMapper.findList((Page<KmsSapOrderFormRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsSapOrderFormRespVo query(KmsSapOrderFormReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsSapOrderFormReqVo reqVo) {
        KmsSapOrderFormEntity entity = (KmsSapOrderFormEntity)CrmBeanUtil.copy((Object)reqVo, KmsSapOrderFormEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsSapOrderFormReqVo reqVo) {
        KmsSapOrderFormEntity entity = (KmsSapOrderFormEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsSapOrderFormReqVo reqVo) {
        List kmsSapOrderFormEntities = this.kmsSapOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsSapOrderFormEntities)) {
            kmsSapOrderFormEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsSapOrderFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsSapOrderFormReqVo reqVo) {
        List kmsSapOrderFormEntities = this.kmsSapOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsSapOrderFormEntities)) {
            kmsSapOrderFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsSapOrderFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsSapOrderFormReqVo reqVo) {
        List kmsSapOrderFormEntities = this.kmsSapOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsSapOrderFormEntities)) {
            kmsSapOrderFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsSapOrderFormEntities);
    }
}

