/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.supermarket.req.KmsSupplierReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsSupplierRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.supermarket.mapper.KmsSupplierMapper;
import com.biz.crm.supermarket.model.KmsSupplierEntity;
import com.biz.crm.supermarket.service.IKmsSupplierService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsSupplierServiceExpandImpl"})
public class KmsSupplierServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsSupplierMapper, KmsSupplierEntity>
implements IKmsSupplierService {
    private static final Logger log = LoggerFactory.getLogger(KmsSupplierServiceImpl.class);
    @Resource
    private KmsSupplierMapper kmsSupplierMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsSupplierRespVo> findList(KmsSupplierReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsSupplierRespVo> list = this.kmsSupplierMapper.findList((Page<KmsSupplierRespVo>)page, reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsSupplierRespVo query(KmsSupplierReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636eID");
        KmsSupplierEntity byId = (KmsSupplierEntity)this.getById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)byId, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        KmsSupplierRespVo copy = (KmsSupplierRespVo)CrmBeanUtil.copy((Object)byId, KmsSupplierRespVo.class);
        return copy;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsSupplierReqVo reqVo) {
        this.checkParams(reqVo);
        KmsSupplierEntity entity = (KmsSupplierEntity)CrmBeanUtil.copy((Object)reqVo, KmsSupplierEntity.class);
        this.save(entity);
        KmsSupplierRespVo newData = (KmsSupplierRespVo)CrmBeanUtil.copy((Object)entity, KmsSupplierRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    private void checkParams(KmsSupplierReqVo reqVo) {
        List collect;
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbId[bsDirectSystemId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801[bsDirectSystemCode]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0[bsDirectSystemName]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSellPartyId(), (String)"\u552e\u8fbe\u65b9ID[sellPartyId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801[sellPartyCode]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSellPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0[sellPartyName]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801[supplierCode]\u4e0d\u80fd\u4e3a\u7a7a");
        List entities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(KmsSupplierEntity::getBsDirectSystemId, (Object)reqVo.getBsDirectSystemId())).eq(KmsSupplierEntity::getSellPartyId, (Object)reqVo.getSellPartyId())).eq(KmsSupplierEntity::getSupplierCode, (Object)reqVo.getSupplierCode())).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)entities) && !org.springframework.util.CollectionUtils.isEmpty(collect = entities.stream().filter(o -> !o.getId().equals(reqVo.getId())).collect(Collectors.toList()))) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u914d\u7f6e");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsSupplierReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636eID");
        this.checkParams(reqVo);
        KmsSupplierEntity byId = (KmsSupplierEntity)this.getById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)byId, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        BeanUtils.copyProperties((Object)reqVo, (Object)byId);
        KmsSupplierRespVo oldData = (KmsSupplierRespVo)CrmBeanUtil.copy((Object)byId, KmsSupplierRespVo.class);
        this.updateById(byId);
        KmsSupplierRespVo newData = this.query(reqVo);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsSupplierReqVo reqVo) {
        List kmsSupplierEntities = this.kmsSupplierMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsSupplierEntities)) {
            kmsSupplierEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsSupplierEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsSupplierReqVo reqVo) {
        List kmsSupplierEntities = this.kmsSupplierMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsSupplierEntities)) {
            kmsSupplierEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsSupplierEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsSupplierReqVo reqVo) {
        List kmsSupplierEntities = this.kmsSupplierMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsSupplierEntities)) {
            kmsSupplierEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsSupplierEntities);
    }
}

